package com.sfa.job.util;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.lark.oapi.okhttp.*;
import com.sfa.common.core.exception.ServiceException;
import com.sfa.job.config.WangdiantongConfig;
import com.sfa.job.pojo.response.WangdiantongQueryDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@Slf4j
@Component
public class WangdiantongUtil {

//    @Value("${wangdiantong.url}")
//    private String url;
//    @Value("${wangdiantong.sid}")
//    private String sid ;
//    @Value("${wangdiantong.key}")
//    private  String key ;
//    @Value("${wangdiantong.salt}")
//    private String salt ;
//    @Value("${wangdiantong.appsecret}")
//    private String appsecret;

    private final WangdiantongConfig wangdiantongConfig;

    @Autowired
    public WangdiantongUtil(WangdiantongConfig wangdiantongConfig) {
        this.wangdiantongConfig = wangdiantongConfig;
    }

    /**
     * 卖家账号/接口账号/盐/接口名称
     */
    public WangdiantongQueryDto queryWithDetail(HashMap<String, Object> params, Integer beginPageNo, String method) {
        WangdiantongQueryDto wangdiantongQueryDto = new WangdiantongQueryDto();
        JSONArray allArray = new JSONArray();
        Integer totalCount = 0;
        try {
            // 最大处理量，超过了，不再查询
            int maxDealCount = 1000;
            int size = 0;
            int pageNo = beginPageNo.intValue();
            // 出现了查询的分页数量不足的情况
            int maxPage = 0;
            do {
                // 使用配置类中的属性
                String url = wangdiantongConfig.getUrl();
                String sid = wangdiantongConfig.getSid();
                String key = wangdiantongConfig.getKey();
                String salt = wangdiantongConfig.getSalt();
                String appsecret = wangdiantongConfig.getAppsecret();
                String v = "1.0";
                List<HashMap<String, Object>> paramsList = Arrays.asList(params);
                String signParams = appsecret + "body" + JSONObject.toJSONString(paramsList) + "calc_total1" + "key" + key
                        + "method" + method + "page_no" + pageNo + "page_size200" + "salt" + salt + "sid" + sid +
                        "timestamp" + (System.currentTimeMillis() / 1000 - 1325347200) + "v" + v + appsecret;
                String sign = DigestUtils.md5DigestAsHex(signParams.toString().getBytes());
                log.debug(signParams);
                log.debug(sign);

                StringBuilder urlParams = new StringBuilder()
                        .append("sid=").append(sid)
                        .append("&key=").append(key)
                        .append("&salt=").append(salt)
                        .append("&method=").append(method)
                        .append("&v=").append(v)
                        .append("&timestamp=").append(System.currentTimeMillis() / 1000 - 1325347200)
                        .append("&sign=").append(sign)
                        .append("&page_size=").append(200)
                        .append("&page_no=").append(pageNo)
                        .append("&calc_total=").append(1);

                log.info("查询订单数据url:" + url + "?" + urlParams);

                RequestBody body = RequestBody.create(MediaType.get("application/json"), JSONObject.toJSONString(paramsList));
                Request urlRequestBuild = new Request.Builder().url(url + "?" + urlParams).post(body).build();
                OkHttpClient client = new OkHttpClient();
                Response execute = client.newCall(urlRequestBuild).execute();
                JSONObject responseJson = JSONObject.parseObject(execute.body().string());
                JSONObject dataR = responseJson.getJSONObject("data");
                JSONObject messageJson = responseJson.getJSONObject("message");
                if (ObjectUtils.isNotEmpty(messageJson)) {
                    log.error("访问旺店通接口错误" + messageJson.toString());
                    throw new ServiceException("访问旺店通接口错误" + messageJson.toString());
                }
                totalCount = dataR.getInteger("total_count");
                maxPage = (totalCount + 199) / 200;

                JSONArray orderJsonArray = dataR.getJSONArray("order");
                allArray.addAll(orderJsonArray);

                size = allArray.size();
                log.info("当前入参{},查询返回的order条数:{},总条数totalCount:{},page_no:{}", JSONObject.toJSONString(params), orderJsonArray.size(), totalCount, pageNo);
                // 计算下一次分页的页码
                pageNo++;
            } while (size < maxDealCount && pageNo <= maxPage);
            if (pageNo >= maxPage) {
                // 已经到最后一页了，设置成-1，表示已经处理完了，不再查询
                beginPageNo = -1;
            } else {
                beginPageNo = pageNo;
            }
            wangdiantongQueryDto.setNextBeginPageNo(beginPageNo);
            wangdiantongQueryDto.setResult(allArray);
            wangdiantongQueryDto.setTotalCount(totalCount);
        } catch (Exception e) {
            // 记录异常日志
            log.error("异常信息：{}" + e.getMessage(), e);
            throw new ServiceException("旺店通接口获取数据错误" + e.getMessage());
        }
        return wangdiantongQueryDto;

    }
}
