package com.sfa.job.service.system;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.sfa.common.core.utils.sdk.FeiShuUtil;
import com.sfa.job.domain.system.dao.ISysDeptDao;
import com.sfa.job.domain.system.dao.ISysUserDao;
import com.sfa.job.domain.system.entity.SysDept;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-12-06 18
 * @describe :
 */
@Slf4j
@Service
public class DeptAndUserServiceImpl implements IDeptAndUserService {

    @Autowired
    private FeiShuUtil feiShuUtil;
    @Autowired
    private ISysDeptDao sysDeptDao;
    @Autowired
    private ISysUserDao sysUserDao;

    /**
     * 从飞书同步全量部门信息
     */
    @Override
    public void deptAll() {
        // 根部门编码
        String cDeptId = "0";
        JSONArray depts = feiShuUtil.getDeptByParentId(cDeptId);

        SysDept sysDept = sysDeptDao.selectByDeptCode(cDeptId);

        for (Object dept : depts){
            SysDept sysDept2 = insertOrUpdateDept(dept, sysDept);
            deptSub(sysDept2.getDeptCode());
        }

    }

    /**
     * 从飞书同步用户信息
     * 按部门同步
     */
    @Override
    public void userAll() {
//        查询所有有效部门，deptCode对应飞书deptId
        List<SysDept> depts = sysDeptDao.selectListByStatus();
        for (SysDept dept : depts) {
            JSONArray users = feiShuUtil.getUsersByDeptId(dept.getDeptCode());
            if (users == null || users.size() == 0){
                log.info("{}部门暂无员工；",dept.getDeptName());
                continue;
            }
            insertOrUpdateUsers(users,dept.getDeptId());
        }

        sysUserDao.updateDeptLeader();
    }

    /**
     * 同步二级以下部门
     */
    private void deptSub(String parentDeptCode) {
        JSONArray depts = feiShuUtil.getDeptByParentId(parentDeptCode);
        if (depts == null || depts.size() == 0){
            return;
        }

        SysDept sysDept = sysDeptDao.selectByDeptCode(parentDeptCode);

        // 遍历部门
        for (Object dept : depts){
            SysDept sysDept2 = insertOrUpdateDept(dept, sysDept);
            deptSub(sysDept2.getDeptCode());
        }

    }

    /**
     * 新增或更新部门
     */
    private SysDept insertOrUpdateDept(Object dept,SysDept parentDept) {
        JSONObject jo = JSONObject.parseObject(JSONObject.toJSONString(dept));
        return sysDeptDao.insertOrUpdate(jo,parentDept);
    }

    private void insertOrUpdateUsers(JSONArray users,Long deptId){
        for (Object user : users) {
            JSONObject jo = JSONObject.parseObject(JSONObject.toJSONString(user));
            sysUserDao.insertOrUpdate(jo,deptId);
        }
    }
}
