package com.sfa.job.domain.system.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 部门表
 * @TableName sys_dept
 */
@TableName(value ="sys_dept")
@Data
public class SysDept implements Serializable {
    /**
     * 部门id
     */
    @TableId(type = IdType.AUTO)
    private Long deptId;

    /**
     * 部门编号(飞书-department_id)
     */
    private String deptCode;

    /**
     * 部门名称
     */
    private String deptName;

    /**
     * 飞书部门IDopen_department_id
     */
    private String fsDeptId;

    /**
     * 父部门id
     */
    private Long parentId;

    /**
     * 父部门编号
     */
    private String parentCode;

    /**
     * 父部门名称
     */
    private String parentName;

    /**
     * 父部门飞书部门ID
     */
    private String parentFsId;

    /**
     * 祖级id列表
     */
    private String ancestors;

    /**
     * 部门编码Path
     */
    private String ancestorCodes;

    /**
     * 部门名称Path
     */
    private String ancestorNames;

    /**
     * 显示顺序
     */
    private Integer orderNum;

    /**
     * 负责人姓名
     */
    private String leader;

    /**
     * 飞书负责人id
     */
    private String fsLeaderId;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 部门人数
     */
    private Integer memberCount;

    /**
     * 部门状态（0正常 1停用）
     */
    private String status;

    /**
     * 删除标志（0代表存在 2代表删除）
     */
    private String delFlag;

    /**
     * 创建者
     */
    private String createBy;

    /**
     * 创建人UserID
     */
    private Long createUserId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新者
     */
    private String updateBy;

    /**
     * 修改人UserID
     */
    private Long updateUserId;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}