package com.sfa.job.domain.order.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 退换货订单数据
 * @author lvbencai
 * @date 2025-02-28 12:26:29
 */
@Data
@TableName(value = "wdt_swap_order_detail")
public class WdtSwapOrderDetail {
    /**
     * 原始子单号
     */
    private String oid;

    /**
     * 货品类型(1 单品,2 组合装)
     */
    private Byte targetType;

    /**
     * 换出货品id
     */
    private Integer targetId;

    /**
     * 是否残次品
     */
    private Boolean defect;

    /**
     * 货品名称
     */
    private String goodsName;

    /**
     * 货品编号
     */
    private String goodsNo;

    /**
     * 规格名称
     */
    private String specName;

    /**
     * 规格码
     */
    private String specCode;

    /**
     * 商家编码
     */
    private String merchantNo;

    /**
     * 零售价
     */
    private BigDecimal price;

    /**
     * 总价
     */
    private BigDecimal totalAmount;

    /**
     * 数量
     */
    private BigDecimal num;

    /**
     * 备注
     */
    private String remark;
}
