package com.sfa.job.domain.erp.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * erp_axmr005出货明细表
 * @TableName erp_axmr005_shipping_details
 */
@TableName(value ="erp_axmr005_shipping_details")
@Data
public class ErpAxmr005ShippingDetails implements Serializable {

    @TableField(exist = false)
    private Integer id;
    /**
     * 出货单号
     */
    @TableId
    private String shippingOrderNumber;

    /**
     * 项次
     */
    private Integer itemSequence;

    /**
     * 营运据点
     */
    private String operatingSite;

    /**
     * 单据日期
     */
    private Date documentDate;

    /**
     * 扣账日期
     */
    private Date debitDate;

    /**
     * 起运日期
     */
    private Date shippingDate;

    /**
     * 出货性质
     */
    private String shippingNature;

    /**
     * 状态
     */
    private String status;

    /**
     * 销退方式
     */
    private String salesReturnMethod;

    /**
     * 业务人员
     */
    private String salesStaff;

    /**
     * 业务人员姓名
     */
    private String salesStaffName;

    /**
     * 业务部门
     */
    private String salesDepartment;

    /**
     * 业务部门简称
     */
    private String salesDepartmentAbbr;

    /**
     * 订单客户
     */
    private String orderCustomer;

    /**
     * 客户简称
     */
    private String customerAbbr;

    /**
     * 收货客户
     */
    private String receivingCustomer;

    /**
     * 收货客户简称
     */
    private String receivingCustomerAbbr;

    /**
     * 收款客户
     */
    private String paymentCustomer;

    /**
     * 收款客户简称
     */
    private String paymentCustomerAbbr;

    /**
     * 国家
     */
    private String country;

    /**
     * 国家说明
     */
    private String countryDescription;

    /**
     * 省
     */
    private String province;

    /**
     * 省份说明
     */
    private String provinceDescription;

    /**
     * 县/市
     */
    private String countyCity;

    /**
     * 县/市说明
     */
    private String countyCityDescription;

    /**
     * 行政区域
     */
    private String administrativeRegion;

    /**
     * 行政区域说明
     */
    private String administrativeRegionDescription;

    /**
     * 送货地址
     */
    private String deliveryAddress;

    /**
     * 地址
     */
    private String address;

    /**
     * 运输方式
     */
    private String transportationMethod;

    /**
     * 运输方式说明
     */
    private String transportationMethodDescription;

    /**
     * 快递单号
     */
    private String expressNumber;

    /**
     * 订单单号
     */
    private String orderNumber;

    /**
     * 项次
     */
    private Integer itemSequenceAgain;

    /**
     * 订单状态
     */
    private String orderStatus;

    /**
     * 项序
     */
    private Integer itemOrder;

    /**
     * 分批序
     */
    private Integer batchSequence;

    /**
     * 客户订购单号
     */
    private String customerOrderNumber;

    /**
     * 客户料号
     */
    private String customerMaterialNumber;

    /**
     * 客户料号品名
     */
    private String customerMaterialName;

    /**
     * 客户料号规格
     */
    private String customerMaterialSpecification;

    /**
     * 子件特性
     */
    private String subPartFeature;

    /**
     * 产品分类
     */
    private String productCategory;

    /**
     * 产品分类说明
     */
    private String productCategoryDescription;

    /**
     * 销售分群
     */
    private String salesGroup;

    /**
     * 销售分群说明
     */
    private String salesGroupDescription;

    /**
     * 料件编号
     */
    private String materialNumber;

    /**
     * 品名
     */
    private String productName;

    /**
     * 规格
     */
    private String productSpecification;

    /**
     * 品牌
     */
    private String brand;

    /**
     * 克重
     */
    private BigDecimal weightGram;

    /**
     * 口味说明
     */
    private String tasteDescription;

    /**
     * 克重
     */
    private String weightGramAgain;

    /**
     * 克重说明
     */
    private String weightGramDescription;

    /**
     * 产品特征
     */
    private String productFeature;

    /**
     * 产品特征说明
     */
    private String productFeatureDescription;

    /**
     * 数量
     */
    private Integer quantity;

    /**
     * 出货单位
     */
    private String shippingUnit;

    /**
     * 已验收数量
     */
    private Integer acceptedQuantity;

    /**
     * 已签退量
     */
    private Integer signedBackQuantity;

    /**
     * 未签收量
     */
    private Integer unsignedQuantity;

    /**
     * 库位
     */
    private String storageLocation;

    /**
     * 库位名称
     */
    private String storageLocationName;

    /**
     * 储位
     */
    private String storagePosition;

    /**
     * 储位名称
     */
    private String storagePositionName;

    /**
     * 批号
     */
    private String batchNumber;

    /**
     * 库存管理特征
     */
    private String inventoryManagementFeature;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 单价
     */
    private BigDecimal unitPrice;

    /**
     * 含税金额
     */
    private BigDecimal amountWithTax;

    /**
     * 税额
     */
    private BigDecimal taxAmount;

    /**
     * 币种
     */
    private String currency;

    /**
     * 汇率
     */
    private BigDecimal exchangeRate;

    /**
     * 本币税前金额
     */
    private BigDecimal localPreTaxAmount;

    /**
     * 本币含税金额
     */
    private BigDecimal localAmountWithTax;

    /**
     * 本币税额
     */
    private BigDecimal localTaxAmount;

    /**
     * 折扣金额
     */
    private BigDecimal discountAmount;

    /**
     * 折扣金额(开票)
     */
    private BigDecimal discountAmountInvoice;

    /**
     * 多角序号
     */
    private String multiAngleSequenceNumber;

    /**
     * 客户分类
     */
    private String customerCategory;

    /**
     * 客户分类说明
     */
    private String customerCategoryDescription;

    /**
     * 销售渠道
     */
    private String salesChannel;

    /**
     * 销售渠道说明
     */
    private String salesChannelDescription;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 类型说明
     */
    private String typeDescription;

    /**
     * 备注
     */
    private String remarksAgain;

    /**
     * 物流备注
     */
    private String logisticsRemarks;

    /**
     * 第三方系统标识码
     */
    private String thirdPartySystemCode;

    /**
     * 资料录入日期
     */
    private Date dataEntryDate;

    /**
     * 打款类型说明
     */
    private String paymentTypeDescription;

    /**
     * 订单拆单状态
     */
    private String orderSplitStatus;

    /**
     * 基础单位
     */
    private String baseUnit;

    /**
     * 订单基础单位数量
     */
    private Integer orderBaseUnitQuantity;

    /**
     * 标准成本
     */
    private BigDecimal standardCost;

    /**
     * 实际成本
     */
    private BigDecimal actualCost;

    /**
     * 采集批次
     */
    private String collectionBatch;

    /**
     * 采集时间
     */
    private Date collectionTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}