package com.sfa.job.service.system;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.sfa.common.core.utils.sdk.FeiShuUtil;
import com.sfa.job.domain.qince.dao.IQinceEmployeeDao;
import com.sfa.job.domain.system.dao.ISysDeptDao;
import com.sfa.job.domain.system.dao.ISysEventLogDao;
import com.sfa.job.domain.system.dao.ISysUserDao;
import com.sfa.job.domain.system.entity.SysDept;
import com.sfa.job.pojo.response.SysEventLogDto;
import com.sfa.job.util.QinCeUtils;
import com.sfa.job.util.T100Util;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-12-06 18
 * @describe :
 */
@Slf4j
@Service
public class DeptAndUserServiceImpl implements IDeptAndUserService {

    @Autowired
    private FeiShuUtil feiShuUtil;
    @Autowired
    private ISysDeptDao sysDeptDao;
    @Autowired
    private ISysUserDao sysUserDao;
    @Autowired
    private IQinceEmployeeDao qinceEmployeeDao;
    @Autowired
    private ISysEventLogDao sysEventLogDao;
    @Autowired
    private QinCeUtils qinCeUtils;
    @Autowired
    private T100Util t100Util;
    /**
     * 从飞书同步全量部门信息
     */
    @Override
    public void deptAll() {
        // 根部门编码
        String cDeptId = "0";
        JSONArray depts = feiShuUtil.getDeptByParentId(cDeptId);

        SysDept sysDept = sysDeptDao.selectByDeptCode(cDeptId);

        for (Object dept : depts){
            SysDept sysDept2 = insertOrUpdateDept(dept, sysDept);
            deptSub(sysDept2.getDeptCode());
        }

    }

    /**
     * 从飞书同步用户信息
     * 按部门同步
     */
    @Override
    public void userAll() {
//        查询所有有效部门，deptCode对应飞书deptId
        List<SysDept> depts = sysDeptDao.selectListByStatus();
        for (SysDept dept : depts) {
            JSONArray users = feiShuUtil.getUsersByDeptId(dept.getDeptCode());
            if (users == null || users.size() == 0){
                log.info("{}部门暂无员工；",dept.getDeptName());
                continue;
            }
            insertOrUpdateUsers(users,dept.getDeptId());
        }
        sysUserDao.updateDeptLeader();
        sysUserDao.updateUserLeader();
    }

    @Override
    public void userResigned(String employeeNo) {
        //1、链路中心人员离职 - 根据工号
        sysUserDao.deleteUser(employeeNo);

        //2、勤策人员离职 - 根据工号+勤策ID
        try {
            String empQcId = qinceEmployeeDao.getQcIdByEmpCode(employeeNo);
            if (StringUtils.isEmpty(empQcId)){
                return;
            }
            Map<String, Object> map = qinCeUtils.disabledUserParams(employeeNo,empQcId);
            String url = qinCeUtils.builderUrl(QinCeUtils.MODIFY_USER, map);
            qinCeUtils.postQC(url, map);
            qinceEmployeeDao.userResigned(empQcId);
        }catch (Exception e){
            log.error("勤策接口禁用用户异常，详情：{}",e.getMessage());
        }

        // 3、T100人员离职
        try{
            JSONObject json = new JSONObject();
            String msg = t100Util.userResigned(employeeNo,"X",json);
            SysEventLogDto eventDto = new SysEventLogDto()
                    .setEventName("T100 user status")
                    .setEventGroup("T100 user")
                    .setRequestMsg(JSONObject.toJSONString(json))
                    .setResponseMsg(msg);
            sysEventLogDao.insert(eventDto);
        }catch (Exception e){
            log.error("T100接口禁用用户异常，详情：{}",e.getMessage());
        }
    }

    @Override
    public void usersResigned() {
        // 查询离职日期是今日及以前，且状态是未离职人员
        List<String> resignedUsers = sysUserDao.selectResignedUsers();
        if (CollectionUtils.isEmpty(resignedUsers)){
            log.info("今日暂无需要处理的离职人员；");
            return;
        }

        for (String userCode : resignedUsers){
            userResigned(userCode);
        }
    }

    /**
     * 同步二级以下部门
     */
    private void deptSub(String parentDeptCode) {
        JSONArray depts = feiShuUtil.getDeptByParentId(parentDeptCode);
        if (depts == null || depts.size() == 0){
            return;
        }

        SysDept sysDept = sysDeptDao.selectByDeptCode(parentDeptCode);

        // 遍历部门
        for (Object dept : depts){
            SysDept sysDept2 = insertOrUpdateDept(dept, sysDept);
            deptSub(sysDept2.getDeptCode());
        }

    }

    /**
     * 新增或更新部门
     */
    private SysDept insertOrUpdateDept(Object dept,SysDept parentDept) {
        JSONObject jo = JSONObject.parseObject(JSONObject.toJSONString(dept));
        return sysDeptDao.insertOrUpdate(jo,parentDept);
    }

    private void insertOrUpdateUsers(JSONArray users,Long deptId){
        for (Object user : users) {
            JSONObject jo = JSONObject.parseObject(JSONObject.toJSONString(user));
            sysUserDao.insertOrUpdate(jo,deptId);
        }
    }
}
