package com.sfa.job.pojo.qince.response;

import lombok.Data;
import org.springframework.cglib.core.Local;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 勤策考勤明细表 DTO 类
 * 对应表：qince_user_statistic
 * 表注释：勤策考勤明细表- 每天同步三次
 *
 * @author douxinyu
 * @date 2026-01-28
 */
@Data
public class QinceUserStatisticDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID 唯一标识
     */
    private Long id;

    /**
     * 部门名称
     */
    private String deptName;

    /**
     * 勤策用户ID
     */
    private Long qcUserId;

    /**
     * 性别
     */
    private String sex;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 所属考勤组
     */
    private String group;

    /**
     * 用户工号
     */
    private String employeeCode;

    /**
     * 定位是否虚假模拟位置。0：非虚假模拟位置，1：虚假模拟位置
     */
    private Integer checkInAttdLieLocate;

    /**
     * 上班打卡位置
     */
    private String checkInAttdAddress;

    /**
     * 上班是否脱岗。0：正常，1：脱岗
     */
    private Integer checkInAttdLcError;

    /**
     * 上班考勤状态。0：正常，1：迟到，2：异常
     */
    private Integer checkInAttdStatus;

    /**
     * 上班打卡时间
     */
    private LocalDateTime checkInAttdTime;

    /**
     * 考勤日期
     */
    private LocalDate attDate;

    /**
     * 工作时长
     */
    private Double workTime;

    /**
     * 备注信息
     */
    private String remarks;

    /**
     * 下班定位是否虚假模拟位置。0：非虚假模拟位置，1：虚假模拟位置
     */
    private Integer checkOutAttdLieLocate;

    /**
     * 下班打卡位置
     */
    private String checkOutAttdAddress;

    /**
     * 下班是否脱岗。0：正常，1：脱岗
     */
    private Integer checkOutAttdLcError;

    /**
     * 下班考勤状态。0：正常，1：迟到，2：异常
     */
    private Integer checkOutAttdStatus;

    /**
     * 下班考勤时间
     */
    private LocalDateTime checkOutAttdTime;

    /**
     * 删除标记。0：删除 1：正常
     */
    private Integer isDelete = 1;

    /**
     * 创建时间
     */
    private LocalDateTime  createTime;

    /**
     * 修改时间
     */
    private LocalDateTime  modifyTime;

}