package com.sfa.job.domain.order.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 采集订单日志信息
 *
 * @TableName collect_order_log_info
 * @author lvbencai
 * @date 2025-01-16 22:58:38
 * @description
 */
@Data
@TableName("collect_order_log")
public class CollectOrderLog implements Serializable {

    /**
     * 唯一键，用于唯一标识采集订单日志信息记录
     */
    @TableId(value = "cli_id",type= IdType.AUTO)
    private Long cliId;
    /**
     * 方法，用于区分不同类别的同步
     */
    private String method;
    /**
     * 备注，记录数量
     */
    private String remark;
    private Integer totalCount;

    /**
     * 采集订单的数量，存储为字符串，长度不超过 20 个字符
     */
    private Date startTime;

    /**
     * 采集订单的详细数量，存储为字符串，长度不超过 20 个字符
     */
    private Date endTime;
    /**
     * 采集订单的详细数量，存储为字符串，长度不超过 20 个字符
     */;

    /**
     * 采集批次信息，可存储长度不超过 30 个字符，使用 utf8mb4 字符集和 utf8mb4_0900_ai_ci 校对规则
     */
    private String batchNo;

    /**
     * 采集的最新时间，代表上一次采集的结束时间，存储为日期时间类型
     */
    private Date latestTime;
    // 2025年01月22日17:24:37增加，用于分批次查询
    private Integer pageNo;

    /**
     * 是否删除的标志，'0' 表示未删除，'1' 表示已删除，使用 utf8mb3 字符集和 utf8mb3_general_ci 校对规则
     */
    private String delFlag;

    /**
     * 创建者信息，存储为长度不超过 20 个字符的字符串
     */
    private String createBy;

    /**
     * 创建人的用户 ID，存储为长整型
     */
    private Long createUserId;

    /**
     * 创建时间，存储为日期时间类型，使用数据库的当前时间作为默认值
     */
    private Date createTime;

    /**
     * 更新者信息，存储为长度不超过 20 个字符的字符串
     */
    private String updateBy;

    /**
     * 修改人的用户 ID，存储为长整型
     */
    private Long updateUserId;

    /**
     * 更新时间，存储为日期时间类型，更新时自动更新为当前时间
     */
    private Date updateTime;

    /**
     * 同步类型，
     * 接口为1手动同步，0 xxljob自动同步
     */
    private Integer syncType;


}
