package com.sfa.job.service.qince.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sfa.job.domain.feishu.dao.IQinceMarketEmployeeDao;
import com.sfa.job.domain.qince.dao.IQinceClienteleStoreDao;
import com.sfa.job.domain.qince.dao.IQinceDealerDao;
import com.sfa.job.pojo.feishu.response.QinceMarketEmployeeDto;
import com.sfa.job.pojo.qince.response.QinceClienteleStoreDto;
import com.sfa.job.pojo.qince.response.QinceDealerDto;
import com.sfa.job.service.qince.IQinceDealerQueryService;
import com.sfa.job.util.QinCeUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.groovy.util.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author : liqiulin
 * @date : 2025-04-24 16
 * @describe :
 */
@Slf4j
@Service
public class QinceDealerQueryServiceImpl implements IQinceDealerQueryService {

    @Autowired
    private IQinceDealerDao qinceDealerDao;
    @Autowired
    private IQinceClienteleStoreDao qinceClienteleStoreDao;
    @Autowired
    private IQinceMarketEmployeeDao qinceMarketEmployeeDao;
    @Autowired
    private QinCeUtils qinCeUtils;

    @Override
    public void updateQinceDealerInfo() {
        /**
         * 查询需要更新的经销商
         */
        List<QinceDealerDto> pushQinceDealers = qinceDealerDao.getPushQinceDealers();

        /**
         * 反写勤策中的自定义字段：大区、战区
         */
        for (QinceDealerDto dealerDTO : pushQinceDealers) {
            try {
                Map<String, Object> ext1 = new HashMap<>();
                ext1.put("dealer_ext_key", "大区");
                ext1.put("dealer_ext_value", dealerDTO.getDqOrgName());

                Map<String, Object> ext2 = new HashMap<>();
                ext2.put("dealer_ext_key", "战区");
                ext2.put("dealer_ext_value", dealerDTO.getZqOrgName());

                Map<String, Object> params = new HashMap<>();
                params.put("dealer_id", dealerDTO.getDealerId());
                params.put("exts", Arrays.asList(ext1, ext2));


                String url = qinCeUtils.builderUrl(QinCeUtils.MODIFY_DEALER, params);
                qinCeUtils.postQC(url, params);

                log.info("更新经销商成功：{}", JSONObject.toJSONString(dealerDTO));
            } catch (RuntimeException e) {
                log.error("更新经销商失败：{}", JSONObject.toJSONString(dealerDTO));
                log.error("失败原因：{}", e.getMessage());
            } catch (Exception e) {
                log.error("更新经销商失败：{}", e.getMessage());
            }
        }

        log.info("更新勤策经销商战区、大区信息完成，更新量：{}", pushQinceDealers.size());
    }

    @Override
    public void queryCusVisitRecord() {
        try {
            // 获取t-1日期
            String queryDate = DateUtil.yesterday().toString(DatePattern.NORM_DATE_PATTERN);
            Map<String, Object> params = qinCeUtils.queryCusVisitRecordParams(queryDate);
            String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_CUS_VISIT_RECORD, params);
            JSONArray recordsJson = qinCeUtils.postArray(url, params);
        } catch (Exception e) {
            log.error("查询城市经理客户拜访失败：{}", e.getMessage());
        }

    }

    @Override
    public void updateQinceStore() {
//        第一步：查询有变动的人员信息：营销中心-逻辑组织架构表
//        第二步：根据每个人员信息，查询出所负责的经销商
//        第三步：根据每家经销商，查询出归属的有效门店
//        第四步：更新每家门店信息：大区、战区取经销商的；城市经理、战区经理、大区总监取人员架构表的

        String dateStr = DateUtil.today();
        List<QinceMarketEmployeeDto> empDtos = qinceMarketEmployeeDao.selectByMd(dateStr);
        for (QinceMarketEmployeeDto empDto : empDtos) {

            List<QinceDealerDto> dealers = qinceDealerDao.findListByManagerCode(empDto.getEmpNo());
            for (QinceDealerDto dealer : dealers) {
                List<QinceClienteleStoreDto> storeDtoList = qinceClienteleStoreDao.findListByDealerId(dealer.getDealerId());
                pushQinceStoreInfo(storeDtoList, dealer,empDto);
            }
        }
    }

    private void pushQinceStoreInfo(List<QinceClienteleStoreDto> storeDtoList,QinceDealerDto dealer,QinceMarketEmployeeDto empDto) {
        for (QinceClienteleStoreDto storeDto : storeDtoList) {
            Map<String, Object> params = new HashMap<>();
            try {
                params.put("store_waiqin_id", storeDto.getQcId());
                params.put("store_name", storeDto.getStoreName());

                List<Map<String, String>> exts = new ArrayList<>();
                exts.add(Maps.of("store_ext_key", "城市经理", "store_ext_value", empDto.getCsEmpName()));
                exts.add(Maps.of("store_ext_key", "战区经理", "store_ext_value", empDto.getZqEmpName()));
                exts.add(Maps.of("store_ext_key", "大区总监", "store_ext_value", empDto.getDqEmpName()));
                exts.add(Maps.of("store_ext_key", "大区", "store_ext_value", dealer.getDqOrgName()));
                exts.add(Maps.of("store_ext_key", "战区", "store_ext_value", dealer.getZqOrgName()));
                params.put("exts", exts);

                String url = qinCeUtils.builderUrl(QinCeUtils.MODIFY_STORE, params);
                qinCeUtils.postQC(url, params);
            } catch (Exception e) {
                log.error("勤策门店更新失败：{}\n{}", JSONObject.toJSONString(params), e.getMessage());
            }
        }
    }
}
