package com.sfa.job.domain.order.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.sfa.common.core.web.domain.BaseDo;
import lombok.Data;
import org.apache.commons.lang3.ObjectUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 旺店通订单明细表 wangdiantong_order_detail
 */
@TableName(value = "finance_order_detail")
@Data
public class FinanceOrderDetail extends BaseDo {
    // 订单唯一键
    private Long tradeId;
    // 订单明细唯一键
    @TableId(type = IdType.NONE)
    private Long recId;
    // 平台ID
    private Integer platformId;
    // 原始子单号
    private String srcOid;
    // 原始单号
    private String srcTid;
    // 赠品方式 0、非赠品
    // 1、自动赠送 2、手工赠送 4、周期购赠送 8、平台赠送 32、阶梯满赠 64、CRM追加赠送 128 主品
    private Integer giftType;
    // 0:未付款 1:部分付款 2:已付款（原始订单的支付状态）
    private Integer payStatus;
    // 退款状态:
    // 0、无退款
    // 1、取消退款
    // 2、申请退款
    // 3、待退款
    // 4、待还原
    // 5、退款成功
    // 6、已退（未付款关闭，未付款的取消了）
    private Integer refundStatus;
    // 退款模式:
    // 1、担保
    // 2、非担保
    // 3、在线非担保
    private Integer guaranteeMode;
    // 如果没有对应的原始单明细,则返回0.
    // 平台状态:
    // 10、未确认
    // 20、待尾款
    // 30、待发货
    // 40、部分发货
    // 50、已发货
    // 60、已签收
    // 70、已完成
    // 80、已退款
    // 90、已关闭
    private Integer platformStatus;
    // 发货条件:1、款到发货 2、货到付款(包含部分货到付款)
    // 3、分期付款
    private Integer deliveryTerm;
    // 数量
    private BigDecimal num;
    // 标价，手工新建时使用货品属性中的“零售价”
    private BigDecimal price;
    // 售后退款数量
    private BigDecimal refundNum;
    // 成交价,原始单折扣及分摊之后的价格
    private BigDecimal orderPrice;
    // 分摊后价格，进入ERP后再次调整的价格，默认值与order_price一致
    private BigDecimal sharePrice;
    // 手工调整价,正数为加价,负数为减价,暂未处理
    private BigDecimal adjust;
    // 优惠
    private BigDecimal discount;
    // 分摊后总价=share_price*num
    private BigDecimal shareAmount;
    // 税率
    private BigDecimal taxRate;
    // 货品名称
    private String goodsName;
    // 货品编号
    private String goodsNo;
    // 规格名称
    private String specName;
    // 商家编码
    private String specNo;
    // 规格码
    private String specCode;
    // 组合装编码
    private String suiteNo;
    // 如果是组合装拆分的，此为组合装名称
    private String suiteName;
    // 组合装数量,不受拆分合并影响
    private BigDecimal suiteNum;
    // 组合装分摊后总价
    private BigDecimal suiteAmount;
    // 组合装优惠
    private BigDecimal suiteDiscount;
    // 平台货品名称
    private String apiGoodsName;
    // 平台规格名称
    private String apiSpecName;
    // 平台货品id
    private String apiGoodsId;
    // 平台规格id
    private String apiSpecId;
    // 货品id（系统货品主键）
    private Integer goodsId;
    // 单品id(系统单品主键)
    private Integer specId;
    // 佣金
    private BigDecimal commission;
    // 货品类型
    // 1销售商品
    // 2原材料
    // 3包装
    // 4周转材料
    // 5虚拟商品
    // 6固定资产
    // 0其它
    private Integer goodsType;
    // 订单内部来源:
    // 0：无来源
    // 1：手机
    // 2：聚划算
    // 32：开具电子发票
    // 2048：当日达
    // 4096：次日达
    // 8192：承诺时效
    // 2097152：区域零售
    // 4194304：拼多多厂家代打
    // 8388608：周期购
    // 1048576：预售单
    // 33554432：前N有礼
    // 524288：天猫物流升级
    // 64：按需配送
    // 256：承诺结构化/QIC
    // 16384：商仓鸟配
    private Integer fromMask;
    // 子单备注
    private String remark;
    // 修改时间（毫秒级时间戳，例如：1631861379000）
    private String modified;
    // 创建时间（毫秒级时间戳，例如：1631861379000）
    private String created;
    // 自定义属性1
    private String prop1;
    // 自定义属性2
    private String prop2;
    // 货品重量（子单预估货品总重量）
    private BigDecimal weight;
    // 图片路径
    private String imgUrl;
    // 实发数量（此数量为发货数量,删除操作等于将此值设置为0）
    private BigDecimal actualNum;
    // 条码
    private String barcode;
    // 已付
    private BigDecimal paid;
    // 组合装id
    private Integer suiteId;
    // bind_oid
    private String bindOid;
    // 打印组合装
    // 0：组合装明细
    // 1：组合装及明细
    // 2：组合装
    private Integer printSuiteMode;
    // 1：天猫物流升级-顺丰配送
    // 2：需要回传
    // 4：天猫物流升级-按需配送
    // 8：天猫物流升级-承诺发货时效
    // 16：天猫物流升级-承诺达时效
    // 32：天猫物流升级-预售下沉
    // 64：天猫物流升级-预计到货时效
    // 128：天猫物流升级-配送线路异常
    // 1024：定金链接
    // 2048：补款链接
    // 4096：确认收货
    // （mask类型值. 在判断的时候使用&运算）
    private Integer flag;
    // 库存保留情况
    // 0：未保留（取消的订单或完成）
    // 1：无库存记录
    // 2：未付款
    // 3：已保留待审核
    // 4：待发货
    // 5：预订单库存
    private Integer stockState;
    // 平台已发货
    private boolean isConsigned;
    // 是否付款
    private Integer isReceived;
    // 平台类目主键
    private Integer cid;
    // 最后更新时间，DateTime格式
    private Date modifiedDate;
    // 创建时间，DateTime格式
    private String createdDate;
    // 分摊邮费
    private BigDecimal sharePostPrice;
    // 发票内容
    private String invoiceContent;
    // 支付时间，DateTime格式，取自原始订单支付时间
    private Date payTime;
    // 货品简称
    private String shortName;


    // 分销商昵称
    private String fenxiaoNick;
    // 分销商id
    private String fenxiaoId;
    // 分销商name
    private String fenxiaoName;
    // 批次号
    private String batchNo;
    // 采集开始时间
    private Date startTime;
    // 采集结束时间
    private Date endTime;

    // 2025年01月13日新增字段
    private String tradeNo;

    // 店铺编号
    private String shopNo;
    // 店铺名称
    private String shopName;
    // 店铺备注
    private String shopRemark;
    // 交易状态
    private Integer tradeStatus;
    // 交易时间
    private String tradeTime;
    // 发货时间，订单未发货不返回该字段（毫秒级时间戳，例如：1631861379000）
    private Date consignTime;
    // 收货地区
    private String receiverArea;
    // 主播名称--来自备注字段
    private String zbjName;
    // 主播ID--来自备注字段
    private String zbjId;
    // 主播直播ID--来自备注字段
    private String zbjZbId;
    // 主播销售类型--来自备注字段
    private String zbjSaleType;
    // 主播渠道类型--来自备注字段
    private String zbjQdType;
    // 应收金额
    private BigDecimal receivable;
    // ERP规格名称 --来自T100的定义
    private String specNameErp;
    // ERP口味 --来自T100的定义
    private String flavorErp;
    // 同步类型，接口为1手动同步，0 xxljob自动同步，
    private Integer syncType;
    // 实际成本
    private BigDecimal actualCost;
    // 标准成本
    private BigDecimal standardCost;
    // 系列
    private String series;

    // 实际成本*num 实际总成本
    private BigDecimal sumActualCost;
    // 标准成本*num  标准总成本
    private BigDecimal sumStandardCost;

    /**
     * 是否删除标志0未删除1已删除
     */
    private String delFlag;

    public String getFenxiaoId(FinanceOrder order, Long tradeId) {
        // 如果不为空，解析出
        if (ObjectUtils.isNotEmpty(order.getFenxiaoNick())) {
            String id = extractDistributorId(order.getFenxiaoNick());
            return id;
        }
        return "";
    }

    /**
     * 从输入字符串中提取分销商 ID
     *
     * @param input 包含分销商 ID 的字符串
     * @return 提取出的分销商 ID，如果未找到则返回空字符串
     */

    public String extractDistributorId(String input) {
        // 使用正则表达式匹配id
        Pattern pattern = Pattern.compile("id:(\\d+)；");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public String extractDistributorName(String input) {
        // 使用正则表达式匹配逗号后面的字符
        Pattern pattern = Pattern.compile("；(.*)】");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    /**
     * 根据订单和交易 ID 获取分销商名称
     *
     * @param order   订单
     * @param tradeId 交易 ID
     * @return 分销商名称，如果未找到则返回空字符串
     */
    public String getFenxiaoName(FinanceOrder order, Long tradeId) {
        // 如果不为空，解析出
        if (ObjectUtils.isNotEmpty(order.getFenxiaoNick())) {
            String id = extractDistributorName(order.getFenxiaoNick());
            return id;
        }
        return "";
    }


    public String getFenxiaoNick(FinanceOrder order) {
        return order.getFenxiaoNick();
    }

    public String extractByRegex(String input, String regex) {
        // 使用正则表达式匹配逗号后面的字符
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public void setZbjName(String fenxiaoName, String remark, FinanceOrderDetail sameDetail) {
        if (ObjectUtils.isNotEmpty(sameDetail) && ObjectUtils.isNotEmpty(sameDetail.getZbjName())) {
            this.zbjName = sameDetail.getZbjName();
            return;
        }
        if (ObjectUtils.isNotEmpty(fenxiaoName)) {
            this.zbjName = fenxiaoName;
            return;
        }
        // 如果不为空，解析出
        if (ObjectUtils.isNotEmpty(remark) && remark.contains("直播")) {
            this.zbjName = extractByRegex(remark, "“【直播】”([^;；]*)");
            this.fenxiaoName = this.zbjName;

        }
    }

    public void setZbjId(String remark, FinanceOrderDetail sameDetail) {
        if (ObjectUtils.isNotEmpty(sameDetail) && ObjectUtils.isNotEmpty(sameDetail.getZbjId())) {
            this.zbjId = sameDetail.getZbjId();
            return;
        }
        // 如果不为空，解析出
        if (ObjectUtils.isNotEmpty(remark) && remark.contains("直播间id")) {
            this.zbjId = extractByRegex(remark, "直播间id:([^;；]\\d+)");
        }

    }

    /**
     * 根据分销商和remark备注信息获取主播Id
     *
     * @param fenxiaoId
     * @param remark
     * @param sameDetail
     * @return
     */
    public void setZbjZbId(String fenxiaoId, String remark, FinanceOrderDetail sameDetail) {
        if (ObjectUtils.isNotEmpty(fenxiaoId)) {
            this.zbjZbId = fenxiaoId;
            return;
        }
        if (ObjectUtils.isNotEmpty(sameDetail) && ObjectUtils.isNotEmpty(sameDetail.getZbjZbId())) {
            this.zbjZbId = sameDetail.getZbjZbId();
            return;
        }
        // 如果不为空，解析出
        if (ObjectUtils.isNotEmpty(remark) && remark.contains("主播id")) {
            this.zbjZbId = extractByRegex(remark, "主播id:([^;；]\\d+)");
            this.fenxiaoId = this.zbjZbId;
            return;
        }
    }

    public void setZbjSaleType(String remark, FinanceOrderDetail sameDetail) {
        if (ObjectUtils.isNotEmpty(sameDetail) && ObjectUtils.isNotEmpty(sameDetail.getZbjSaleType())) {
            this.zbjSaleType =  sameDetail.getZbjSaleType();
            return;
        }
        // 如果不为空，解析出
        if (ObjectUtils.isNotEmpty(remark) && remark.contains("销售类型:")) {
            this.zbjSaleType =   extractByRegex(remark, "销售类型:([^;；]*)；");
        }

    }


    public void setZbjQdType(String fenxiaoId, String zbjZbId, Map<String, String> baseZbjType) {
        if (ObjectUtils.isNotEmpty(fenxiaoId)) {
            zbjZbId = fenxiaoId;
        }
        this.zbjQdType = baseZbjType.get(zbjZbId);
        if (ObjectUtils.isNotEmpty(zbjZbId) && ObjectUtils.isEmpty(this.zbjQdType)) {
            this.zbjQdType = baseZbjType.get("其他分销名称");
        }
    }
}
