package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.job.domain.order.dao.IOrdersSentDao;
import com.sfa.job.domain.order.entity.OrdersSent;
import com.sfa.job.domain.order.mapper.OrdersSentMapper;
import com.sfa.job.pojo.response.OrdersSentDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-07-10 16
 * @describe :
 */
@Slf4j
@DS("bi")
@Service
public class OrdersSentDaoImpl implements IOrdersSentDao {
    @Autowired
    private OrdersSentMapper ordersSentMapper;

    /**
     * 查询所有未push到勤策的发货单
     * @return
     */
    @Override
    public List<OrdersSentDto> findByPushqcStatus() {
        List<OrdersSent> sents = ordersSentMapper.findUnsyncQc();
        return BeanUtils.transitionDtos(sents, OrdersSentDto.class);
    }

    /**
     * 根据发货单编号查询发货单
     * @param sentNo 发货单编号
     * @return 发货单
     */
    @Override
    public OrdersSentDto getSent(String sentNo) {
        OrdersSent sentDo = ordersSentMapper.selectBySentNo(sentNo);
        if (Objects.isNull(sentDo)){
            throw new CheckedException(ECode.SENT_ISNULL_ERROR);
        }
        return BeanUtils.transitionDto(sentDo, OrdersSentDto.class);
    }
    /**
     * 根据发货单编号更新push_qc状态
     * @param ahSentNo 发货单编号
     */
    @Override
    public void updatePushqcByAhSentNo(String ahSentNo) {
        ordersSentMapper.updatePushqcByAhSentNo(ahSentNo);
    }

    /**
     * 获取45天内未回单的发货单
     */
    @Override
    public List<OrdersSentDto> getNotReceiptSent() {
        List<OrdersSent> sents = ordersSentMapper.getNotReceiptSent();
        return BeanUtils.transitionDtos(sents, OrdersSentDto.class);
    }

    @Override
    public void updateByExpressNo(OrdersSentDto ordersSentDto) {
        log.info("更新发货单信息：{}", ordersSentDto);
        OrdersSent ordersSent = BeanUtils.transitionDto(ordersSentDto, OrdersSent.class);
        ordersSentMapper.updateByExpressNo(ordersSent);
    }
}
