package com.sfa.job.util;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.google.gson.JsonParser;
import com.lark.oapi.Client;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.service.contact.v3.enums.ChildrenDepartmentDepartmentIdTypeEnum;
import com.lark.oapi.service.contact.v3.enums.FindByDepartmentUserDepartmentIdTypeEnum;
import com.lark.oapi.service.contact.v3.enums.FindByDepartmentUserUserIdTypeEnum;
import com.lark.oapi.service.contact.v3.model.ChildrenDepartmentReq;
import com.lark.oapi.service.contact.v3.model.ChildrenDepartmentResp;
import com.lark.oapi.service.contact.v3.model.FindByDepartmentUserReq;
import com.lark.oapi.service.contact.v3.model.FindByDepartmentUserResp;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author : liqiulin
 * @date : 2024-12-06 16
 * @describe :
 */
@Slf4j
@Component
public class FeiShuUtil {

    /**
     * 根据部门父编码获取子部门
     * 公司编码："0"
     */
    public JSONArray getDeptByParentId(String parentId) {
        try {
            Client client = getClient();
            ChildrenDepartmentReq req = ChildrenDepartmentReq.newBuilder()
                    .departmentId(parentId)
                    .departmentIdType(ChildrenDepartmentDepartmentIdTypeEnum.DEPARTMENT_ID)
                    .pageSize(50)
                    .build();
            ChildrenDepartmentResp resp = client.contact().department().children(req);
            if (!resp.success()) {
                log.error(String.format("code:%s,msg:%s,reqId:%s, resp:%s",
                        resp.getCode(), resp.getMsg(), resp.getRequestId(), Jsons.createGSON(true, false).toJson(JsonParser.parseString(new String(resp.getRawResponse().getBody(), "UTF-8")))));
                return null;
            }
            JSONArray items = JSONObject.parse(Jsons.DEFAULT.toJson(resp.getData())).getJSONArray("items");
            return items;
        } catch (Exception e) {
            log.error("获取子部门列表失败，停止执行！");
        }
        return null;
    }

    public JSONArray getUsersByDeptId(String deptCode) {
        try {
            Client client = getClient();
            FindByDepartmentUserReq req = FindByDepartmentUserReq.newBuilder()
                    .userIdType(FindByDepartmentUserUserIdTypeEnum.OPEN_ID)
                    .departmentIdType(FindByDepartmentUserDepartmentIdTypeEnum.DEPARTMENT_ID)
                    .departmentId(deptCode)
                    .pageSize(50)
                    .build();
            FindByDepartmentUserResp resp = client.contact().user().findByDepartment(req);
            if(!resp.success()) {
                System.out.println(String.format("code:%s,msg:%s,reqId:%s, resp:%s",
                        resp.getCode(), resp.getMsg(), resp.getRequestId(), Jsons.createGSON(true, false).toJson(JsonParser.parseString(new String(resp.getRawResponse().getBody(), "UTF-8")))));
                return null;
            }
            JSONArray items = JSONObject.parse(Jsons.DEFAULT.toJson(resp.getData())).getJSONArray("items");
            return items;
        } catch (Exception e) {
            log.error("获取部门用户失败，停止执行！部门id：{}", deptCode);
        }
        return null;
    }

    private Client getClient() {
        return Client.newBuilder("cli_a7dbe3ec7d9e5013", "WxiT7uIJNDbDpEGfVCXEwNNfN1A3RgUo").build();
    }
}