package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.job.domain.order.dao.IOrdersSentDao;
import com.sfa.job.domain.order.entity.OrdersSent;
import com.sfa.job.domain.order.mapper.OrdersSentMapper;
import com.sfa.job.pojo.response.OrdersSentDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-07-10 16
 * @describe :
 */
@DS("bi")
@Service
public class OrdersSentDaoImpl implements IOrdersSentDao {
    @Autowired
    private OrdersSentMapper ordersSentMapper;
    @Override
    public List<OrdersSentDto> findByPushqcStatus() {
        List<OrdersSent> sents = ordersSentMapper.findUnsyncQc();
        return BeanUtils.transitionDtos(sents, OrdersSentDto.class);
    }

    @Override
    public OrdersSentDto getSent(String sentNo) {
        OrdersSent sentDo = ordersSentMapper.selectBySentNo(sentNo);
        if (Objects.isNull(sentDo)){
            throw new CheckedException(ECode.PARAM_CODE_ISNULL_ERROR);
        }
        return BeanUtils.transitionDto(sentDo, OrdersSentDto.class);
    }

    @Override
    public void updatePushqcByAhSentNo(String ahSentNo) {
        ordersSentMapper.updatePushqcByAhSentNo(ahSentNo);
    }
}
