package com.sfa.job.service.feishu;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.sfa.common.core.utils.sdk.FeiShuUtil;
import com.sfa.job.domain.feishu.dao.IQinceMarketEmployeeDao;
import com.sfa.job.domain.feishu.entity.QinceMarketEmployee;
import com.sfa.job.domain.use.dao.IFeishuSheetRecordDao;
import com.sfa.job.enums.FSRecordEnum;
import com.sfa.job.pojo.response.FeishuSheetRecordDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-05-09 16
 * @describe :
 */
@Service
public class PullSheetServiceImpl implements IPullSheetService{

    @Autowired
    private IFeishuSheetRecordDao feishushetRecordDao;
    @Autowired
    private IQinceMarketEmployeeDao qinceMarketEmployeeDao;
    @Autowired
    private FeiShuUtil feiShuUtil;

    /**
     * 拉取表格 - 勤策门店的城市经理、省区经理、大区总监
     */
    @Override
    public void qinceSotreManage() {
        FeishuSheetRecordDto recordDto = feishushetRecordDao.selectOne(FSRecordEnum.XS_USER_RELATION.getType());
        JSONObject jsonObject = feiShuUtil.pullSheetOneRange(recordDto.getSheetToken(), feiShuUtil.getBotToken1(), recordDto.getRanges());
        JSONArray values = jsonObject.getJSONArray("values");

        List<QinceMarketEmployee> dos = new ArrayList<>();
        for (int i = 0; i < values.size(); i++) {
            JSONArray jsonArray = values.getJSONArray(i);
            // 经销商代码0
            String dealerCode = jsonArray.getString(0);
            // 判断dqEmpNo是否为数字，不是数字不做处理，当是数字时判断是否6位，不足6位用0补齐
            if (dealerCode.matches("\\d+") && dealerCode.length() < 6) {
                dealerCode = String.format("%06d", Integer.parseInt(dealerCode));
            }
            String dealerName = jsonArray.getString(1);
            // 大区部门编码2
            String dqDeptCode = jsonArray.getString(2);
            // 大区总工号4
            String dqEmpNo = jsonArray.getString(4);
            // 战区部门编码6
            String zqDeptCode = jsonArray.getString(6);
            // 战区经理工号8
            String zqEmpNo = jsonArray.getString(8);
            // 城市经理工号10
            String csEmpNo = jsonArray.getString(10);

            QinceMarketEmployee marketDo = new QinceMarketEmployee(dealerCode,dealerName, dqDeptCode, zqDeptCode, dqEmpNo, zqEmpNo, csEmpNo);
            dos.add(marketDo);
        }
        qinceMarketEmployeeDao.insert(dos);
    }
}
