package com.sfa.job.service.order.impl;

import com.alibaba.fastjson.JSONObject;
import com.sfa.job.domain.order.dao.IOrdersSentDao;
import com.sfa.job.pojo.response.OrdersSentDto;
import com.sfa.job.service.order.IOrdersSentQueryService;
import com.sfa.job.util.QinCeUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2025-07-10 16
 * @describe :
 */
@Slf4j
@Service
public class OrdersSentQueryServiceImpl implements IOrdersSentQueryService {

    @Autowired
    private IOrdersSentDao ordersSentDao;
    @Autowired
    private QinCeUtils qinCeUtils;

    @Override
    public void ordersSentToQince() {
        List<OrdersSentDto> sents = ordersSentDao.findByPushqcStatus();
        for (OrdersSentDto sent : sents) {
            // 修改勤策物流https地址
            pushQc(sent);
        }
    }

    @Override
    public OrdersSentDto getSent(String sentNo) {
        return ordersSentDao.getSent(sentNo);
    }

    private void pushQc(OrdersSentDto sent){
        try {
            String wlHtmlPath = qinCeUtils.wlHtmlPath;
            wlHtmlPath += sent.getAhSentNo();
            // 勤策中发货单按安徽匹配
            Map<String, Object> params = qinCeUtils.modifySentDefinedValParams(sent.getAhSentNo(), wlHtmlPath);
            String url = qinCeUtils.builderUrl(QinCeUtils.MODIFY_SENT_DEFINED_VAL, params);
            JSONObject request = qinCeUtils.postQC(url, params);
        }catch (Exception e) {
            log.error("勤策推送物流地址失败，物流信息：{}", JSONObject.toJSONString(sent));
        }

    }
}
