package com.sfa.job.domain.system.dao;

import com.alibaba.fastjson2.JSONObject;
import com.sfa.common.core.enums.StatusType;
import com.sfa.job.domain.system.entity.SysUser;
import com.sfa.job.domain.system.mapper.SysUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-12-10 14
 * @describe :
 */
@Service
public class SysUserDaoImpl implements ISysUserDao{

    @Autowired
    private SysUserMapper sysUserMapper;

    @Override
    public void insertOrUpdate(JSONObject jo, Long deptId) {
        SysUser sysUser = new SysUser();
        sysUser.setCreateBy("admin");
        sysUser.setCreateUserId(1L);
        sysUser.setUpdateBy("admin");
        sysUser.setUpdateUserId(1L);

        sysUser.setDeptId(deptId);
        sysUser.setUserName(jo.getString("employee_no"));
        sysUser.setNickName(jo.getString("name"));
        sysUser.setUserType("00");
        sysUser.setFsUserId(jo.getString("user_id"));
        sysUser.setFsOpenId(jo.getString("open_id"));
        sysUser.setEmail(jo.getString("enterprise_email"));
        sysUser.setPhonenumber(jo.getString("mobile").replace("+86",""));
        sysUser.setSex("2");
        sysUser.setAvatar("");
        sysUser.setPassword("");
        sysUser.setRoleId(0L);
        sysUser.setRoleName("");
        sysUser.setWorkCityName(jo.getString("city"));
        sysUser.setStatus(StatusType.INVALID.getType()+"");

        sysUserMapper.insertOrUpdate(sysUser);
    }

    @Override
    public void updateDeptLeader() {
        sysUserMapper.updateDeptLeader();
    }

    @Override
    public void deleteUser(String employeeNo) {
        sysUserMapper.updateStatus(employeeNo);
    }
}
