package com.sfa.job.controller.order;

import com.alibaba.fastjson2.JSONArray;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.ServiceException;
import com.sfa.common.redis.service.RedisService;
import com.sfa.job.constants.RedisKeyJob;
import com.sfa.job.pojo.response.OrdersSentDto;
import com.sfa.job.service.order.IOrdersSentQueryService;
import com.sfa.job.util.JdtcUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author : liqiulin
 * @date : 2025-07-08 13
 * @describe : 订单 - 发货单物流查询
 */
@RestController
@RequestMapping("/sent")
public class SentQueryController {
    @Autowired
    private JdtcUtil jdtcUtil;
    @Autowired
    private IOrdersSentQueryService orderSentQueryService;
    @Autowired
    private RedisService redisService;

    @GetMapping("/query_p")
    public Object query(String sentNo){
        // 限制单号每小时只能查询5次
        String rKey = RedisKeyJob.QINCE_ORDER_SENT_INTERNET_COUNT + sentNo;
        Object cacheObject = redisService.getCacheObject(rKey);
        if (cacheObject != null && Integer.parseInt(cacheObject.toString()) >= 5) {
            throw new ServiceException(ECode.SENT_NO_QUERY_COUNT_ERROR);
        }
        Object sent = queryBySentNode(sentNo);
        redisService.setCacheObject(rKey, cacheObject == null ? 1 : Integer.parseInt(cacheObject.toString()) + 1);
        return sent;
    }

    private Object queryBySentNode(String sentNo){
        OrdersSentDto sent = orderSentQueryService.getSent(sentNo);
        Object sentInfo = null;
        switch (sent.getTransport()) {
            case "134":
                sentInfo = jdTC134(sent);
                break;
            default:
                throw new ServiceException(ECode.SENT_ISNULL_ERROR);
        }
        sent.setSentInfo(sentInfo);
        return sent;
    }

    private Object jdTC134(OrdersSentDto sent){
        JSONArray traces = jdtcUtil.getOrderTrace(sent.getBjSentNo() + "-" + sent.getBjSentVersion());
        return CollectionUtils.isEmpty(traces) ? null : traces.get(0);
    }
}
