package com.sfa.job.util;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.kyexpress.openapi.sdk.KyeDefaultOpenApi;
import com.kyexpress.openapi.sdk.exception.KyeOpenApiException;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.ServiceException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2025-07-29 17
 * @describe : 跨越物流
 */
@Slf4j
@Component
public class KyeUtil {
    /**
     * =================== Kye API - config ===================
     */
    @Value("${kye.wl_app_key}")
    private String APP_KEY;
    @Value("${kye.wl_app_secret}")
    private String APP_SECRET;
    @Value("${kye.customer_code}")
    private String CUSTOMER_CODE;
    @Value("${kye.platform_flag}")
    private String PLATFORM_FLAG;
    @Value("${kye.is_sandbox}")
    private Boolean IS_SANDBOX;

    /**
     * =================== JDTC API - mothod ===================
     */
    private final String QUERY_ROUTE_M = "open.api.openCommon.queryRoute";
    private final String QUERY_PUBLIC_ROUTE_M = "open.api.openCommon.queryPublicRoute";
    private final String GET_WAYBILL_BASE_INFO_M = "open.api.openCommon.getWaybillBaseInfo";
    private final String QUERY_WAYBILL_PICTURE_M = "open.api.openCommon.queryWaybillPicture";

    /**
     * 物流轨迹
     */
    public JSONArray getOrderTrace(String orderNo){
        try {
            Boolean isSandbox = IS_SANDBOX;
            String appKey = APP_KEY;
            String appSecret = APP_SECRET;
            String customerCode = CUSTOMER_CODE;
            String platformFlag = PLATFORM_FLAG;

            String bizBody = "{\"customerCode\":\""+customerCode+"\",\"waybillNumbers\":[\""+orderNo+"\"],\"platformFlag\":\""+platformFlag+"\"}";
            // 沙盒环境(env=prod && isSandbox=true)
            String response = KyeDefaultOpenApi.builder(appKey, appSecret).env("prod").api(QUERY_PUBLIC_ROUTE_M).sandbox(isSandbox).body(bizBody).connectTimeout(3000).readTimeout(15000).request().response();
            JSONObject rJson = JSONObject.parseObject(response);
            if (!rJson.getBoolean("success")){
                log.error("请求跨越物流轨迹接口返回异常：{}",response);
                throw new ServiceException(ECode.KYE_ORDER_TRACE_API_ERROR);
            }
            return rJson.getJSONObject("data").getJSONArray("esWaybill");
        } catch (KyeOpenApiException e) {
            throw new ServiceException(ECode.KYE_ORDER_TRACE_QUERY_ERROR);
        }
    }

    /**
     * 根据单号获取运单信息
     */
    public JSONArray getWaybillBaseInfo(List<String> waybillNumbers) {
        try {
            Boolean isSandbox = IS_SANDBOX;
            String appKey = APP_KEY;
            String appSecret = APP_SECRET;
            String customerCode = CUSTOMER_CODE;

            Map<String,Object> param = new HashMap<>();
            param.put("customerCode",customerCode);
            param.put("waybillNumber",waybillNumbers);

            String response = KyeDefaultOpenApi.builder(appKey, appSecret).env("prod").api(GET_WAYBILL_BASE_INFO_M).sandbox(isSandbox).body(JSONObject.toJSONString(param)).connectTimeout(3000).readTimeout(15000).request().response();
            JSONObject rJson = JSONObject.parseObject(response);
            if (!rJson.getBoolean("success")){
                log.error("请求跨越[获取运单信息]接口返回异常：{}",response);
                throw new ServiceException(ECode.KYE_ORDER_QUERY_ERROR);
            }
            return rJson.getJSONArray("data");
        } catch (KyeOpenApiException e) {
            throw new ServiceException(ECode.KYE_ORDER_QUERY_ERROR);
        }
    }

    public JSONArray queryWaybillPicture(String expressNo) {
        try {
            Boolean isSandbox = IS_SANDBOX;
            String appKey = APP_KEY;
            String appSecret = APP_SECRET;
            String customerCode = CUSTOMER_CODE;

            Map<String,Object> param = new HashMap<>();
            param.put("customerCode",customerCode);
            param.put("waybillNumber",expressNo);
//            10=运单联、 20=签收联签字笔记、30=回单， 40=完整性照片、50=货物异常、60=签收联、70-货物开箱图、90-货物木架图
            param.put("pictureType","30");

            String response = KyeDefaultOpenApi.builder(appKey, appSecret).env("prod").api(QUERY_WAYBILL_PICTURE_M).sandbox(isSandbox).body(JSONObject.toJSONString(param)).connectTimeout(3000).readTimeout(15000).request().response();
            JSONObject rJson = JSONObject.parseObject(response);
            if (!rJson.getBoolean("success")){
                if (Integer.valueOf(10010).equals(rJson.getInteger("code"))){
                    return new JSONArray();
                }
                log.error("请求跨越[下载图片]接口返回异常：{}：{}",expressNo,response);
                throw new ServiceException(ECode.KYE_ORDER_QUERY_ERROR);
            }
            return rJson.getJSONObject("data").getJSONArray("filePictureInfoRes");
        } catch (KyeOpenApiException e) {
            log.error("跨越SDK异常：{}：{}",expressNo,e.getMessage());
            throw new ServiceException(ECode.KYE_ORDER_QUERY_ERROR);
        }
    }
}
