package com.sfa.job.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @author : liqiulin
 * @date : 2025-04-24 16
 * @describe :
 */
@Slf4j
@Component
public class QinCeUtils {

    /**
     * =================== 勤策API - config ===================
     */
    @Value("${qince.open_api}")
    private String OPEN_API;
    @Value("${qince.open_id}")
    private String OPEN_ID;
    @Value("${qince.app_key}")
    private String APP_KEY;
    @Value("${wxl.wl.html_path}")
    public String wlHtmlPath;
    @Value("${wxl.wl.rrs_path}")
    public String wlRrsPath;
    @Value("${wxl.wl.wly_path}")
    public String wlWlyPath;

    /**
     * =================== 勤策API - path ===================
     */
    // 修改经销商
    public static final String MODIFY_DEALER = "/api/dealer/v1/modifyDealer/";
    public static final String MODIFY_STORE = "/api/store/v1/modifyStore/";
    public static final String QUERY_CUS_VISIT_RECORD = "/api/cusVisit/v1/queryCusVisitRecord/";
    // 直营发货单自定义字段更新
    public static final String MODIFY_SENT_DEFINED_VAL = "/api/dmssent/v1/modifyUseDefinedVal/";
    // 修改人员
    public static final String MODIFY_USER = "/api/employee/v3/modifyEmployee/";



    public String builderUrl(String sidepath, Map<String, Object> params) {
        String msgId = UUID.randomUUID().toString();
        Long currentTimeMillis = System.currentTimeMillis();
        String digest = getDigest(params, currentTimeMillis);
        StringBuilder builder = new StringBuilder().append(OPEN_API).append(sidepath).append(OPEN_ID).append("/").append(currentTimeMillis).append("/").append(digest).append("/").append(msgId);
        return builder.toString();
    }

    public Map<String, Object> queryCusVisitRecordParams(String visitDate){
     Map<String,Object> params = new HashMap<>();
     params.put("date_start",visitDate);
     params.put("date_end",visitDate);
     params.put("page","1");
     params.put("rows","1000");
     return params;
    }

    public Map<String, Object> modifySentDefinedValParams(String sentNo,String wlHtmlPath,String transportName,String exNo){
        Map<String,Object> val1 = new HashMap<>();
        val1.put("ext_key","物流轨迹");
        val1.put("ext_value",wlHtmlPath);
        Map<String,Object> val2 = new HashMap<>();
        val2.put("ext_key","物流承运商");
        val2.put("ext_value",transportName);
        Map<String,Object> val3 = new HashMap<>();
        val3.put("ext_key","物流单号");
        val3.put("ext_value",exNo);

        Map<String,Object> params = new HashMap<>();
        params.put("sent_no",sentNo);
        params.put("exts", Arrays.asList(val1,val2,val3));
        return params;
    }

    public Map<String,Object> disabledUserParams(String userCode,String qcId){
        Map<String,Object> params = new HashMap<>();
        // 员工登录帐号
        params.put("emp_code",userCode);
        params.put("id",qcId);
        // 员工账号状态。0：删除，1：正常，2：停用
        // 不传，默认值为1
        params.put("emp_status", "2");
        return params;
    }

    public Map<String,Object> putUserLeaderParams(String qcId,String leaderQcId){
        Map<String,Object> params = new HashMap<>();
        params.put("id",qcId);
        params.put("waiqin365_parent_id", leaderQcId);
        return params;
    }


    public JSONObject postQC(String url, Object params) throws Exception {
        String requestBody = HttpUtil.createPost(url).contentType("application/json;charset=utf-8").header("","").body(JSONObject.toJSONString(params)).execute().body();
        JSONObject resultJson = JSONObject.parseObject(requestBody);
        String returnCode = resultJson.getString("return_code");
        if (!"0".equals(returnCode)) {
            throw new RuntimeException("OkHttp.post 勤策接口返回值异常，详情：" + requestBody);
        }
        return resultJson;
    }

    private String getDigest(Map<String, Object> params, Long currentTimeMillis) {
        String json = "";
        if (!CollectionUtils.isEmpty(params)) {
            json = JSONObject.toJSONString(params);
        }
        String digest = DigestUtils.md5Hex(json + "|" + APP_KEY + "|" + currentTimeMillis);
        return digest;
    }

    public JSONArray postArray(String url, Map<String, Object> params) throws Exception {
        JSONObject jsonObject = postQC(url, params);
        return jsonObject.getJSONArray("response_data");
    }
}
