package com.sfa.job.controller.order;

import com.sfa.job.pojo.response.SyncOrderDetailDto;
import com.sfa.job.service.order.IWdtQimenOrderPayTimeSyncService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;


/**
 * @author : liqiulin
 * @date : 2025-07-08 13
 * @describe : 订单 - 发货单物流查询
 */
@RestController
@RequestMapping("/order/qimen/")
public class WdtQimenOrderPayTimeController {

    @Autowired
    private IWdtQimenOrderPayTimeSyncService orderQimenSyncService;


    @GetMapping("/syncByPayTime")
    public Object sync(@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date startTime,
                       @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date endTime,
                       @RequestParam(value = "pageSize", required = false, defaultValue = "200") Long pageSize
    ) {
        SyncOrderDetailDto syncOrderDetailDto = orderQimenSyncService.syncWdtQimenOrder(startTime, endTime, 1, pageSize);
        return syncOrderDetailDto;
    }

    @GetMapping("/payTime/syncByTradeNo")
    public Object syncByTradeNo(@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date startTime,
                                @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date endTime,
                                @RequestParam(value = "tradeNo", required = false) String tradeNo,
                                @RequestParam(value = "pageNo", required = false, defaultValue = "1") Long pageNo,
                                @RequestParam(value = "pageSize", required = false, defaultValue = "200") Long pageSize
    ) {
        SyncOrderDetailDto syncOrderDetailDto = orderQimenSyncService.syncWdtQimenOrderByTradeNo(startTime, endTime, 1, tradeNo, pageNo, pageSize);
        return syncOrderDetailDto;
    }

    @GetMapping("/payTime/test")
    public Object syncByPayTime(@RequestParam(value = "year", required = false) Integer year) {
        SyncOrderDetailDto syncOrderDetailDto = orderQimenSyncService.test(year);
        return syncOrderDetailDto;
    }


}
