package com.sfa.job.service.order.impl;


import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sfa.job.domain.order.entity.FinanceBaseZbjType;
import com.sfa.job.domain.order.mapper.FinanceBaseZbjTypeMapper;
import com.sfa.job.service.order.FinanceBaseZbjTypeService;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 旺店通订单Service业务层处理
 *
 * @author lvbencai
 * @date 2025年01月07日17:00:16
 */
@DS("bi")
@Service
public class FinanceBaseZbjTypeServiceImpl extends ServiceImpl<FinanceBaseZbjTypeMapper, FinanceBaseZbjType> implements FinanceBaseZbjTypeService {
    @Override
    public Map<String, String> selectBaseZbjType() {
        List<FinanceBaseZbjType> list = list();
        // 以fenxiaoName为key，直播间渠道类型为value，放入map中
        Map<String, String> map = list.stream()
                .collect(HashMap::new, (k, v) -> k.put(v.getFenxiaoName(), v.getZbjQdType()), HashMap::putAll);
        return map;
    }


}
