package com.sfa.job.util;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.kyexpress.openapi.sdk.KyeDefaultOpenApi;
import com.kyexpress.openapi.sdk.exception.KyeOpenApiException;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.ServiceException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author : liqiulin
 * @date : 2025-07-29 17
 * @describe : 跨越物流
 */
@Slf4j
@Component
public class KyeUtil {
    /**
     * =================== Kye API - config ===================
     */
    @Value("${kye.wl_app_key}")
    private String APP_KEY;
    @Value("${kye.wl_app_secret}")
    private String APP_SECRET;
    @Value("${kye.customer_code}")
    private String CUSTOMER_CODE;
    @Value("${kye.platform_flag}")
    private String PLATFORM_FLAG;
    @Value("${kye.is_sandbox}")
    private Boolean IS_SANDBOX;

    /**
     * =================== JDTC API - month ===================
     */
    private final String QUERY_ROUTE_M = "open.api.openCommon.queryRoute";
    private final String QUERY_PUBLIC_ROUTE_M = "open.api.openCommon.queryPublicRoute";

    public JSONArray getOrderTrace(String orderNo){
        try {
            Boolean isSandbox = IS_SANDBOX;
            String appKey = APP_KEY;
            String appSecret = APP_SECRET;
            String customerCode = CUSTOMER_CODE;
            String platformFlag = PLATFORM_FLAG;

            String bizBody = "{\"customerCode\":\""+customerCode+"\",\"waybillNumbers\":[\""+orderNo+"\"],\"platformFlag\":\""+platformFlag+"\"}";
            // 沙盒环境(env=prod && isSandbox=true)
            String response = KyeDefaultOpenApi.builder(appKey, appSecret).env("prod").api(QUERY_PUBLIC_ROUTE_M).sandbox(isSandbox).body(bizBody).connectTimeout(3000).readTimeout(15000).request().response();
            JSONObject rJson = JSONObject.parseObject(response);
            if (!rJson.getBoolean("success")){
                log.error("请求跨越物流轨迹接口返回异常：{}",response);
                throw new ServiceException(ECode.KYE_ORDER_TRACE_API_ERROR);
            }
            return rJson.getJSONObject("data").getJSONArray("esWaybill");
        } catch (KyeOpenApiException e) {
            throw new ServiceException(ECode.KYE_ORDER_TRACE_QUERY_ERROR);
        }
    }
}
