package com.sfa.job.domain.order.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import java.math.BigDecimal;

/**
 * finance_base_product 表对应的 料号基本信息表。
 * 主要字段实际成本、标准成本、规格、口味
 * @author lvbencai
 * @date 2025年01月07日10:04:25
  */
@Data
public class FinanceBaseProduct {
    // 唯一标识主键
    @TableId(type = IdType.AUTO)
    private Integer fbpId;
    // 料号
    private String prdCode;
    // 品名
    private String prdName;
    // 规格
    private String prdBarCode;
    // 实际成本
    private BigDecimal actualCost;
    // 标准成本
    private BigDecimal standardCost;
    // 一级分类
    private String firstCategory;
    // 二级分类
    private String secondCategory;
    // 规格
    private String spec;
    // 口味
    private String flavor;
    // 系列
    private String series;

    // 产品分类编码
    private String productClassificationCode;
    // 产品分类
    private String productClassification;
    // 主分群码（重复字段，可根据实际需求调整）
    private String mainGroupCode;
    // 主分群码名称
    private String mainGroupName;
    // 料件类别（重复字段，可根据实际需求调整）
    private String materialType;
    // 料件类别描述
    private String materialTypeName;
    // 基础单位
    private String basicUnit;
    // 生命周期状态
    private String lifeCycleStatus;
    // 生命周期
    private String lifeCycle;
}
