package com.sfa.job.controller.order;

import com.alibaba.fastjson2.JSONArray;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.ServiceException;
import com.sfa.job.pojo.response.OrdersSentDto;
import com.sfa.job.service.order.IOrdersSentQueryService;
import com.sfa.job.util.JdtcUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;


/**
 * @author : liqiulin
 * @date : 2025-07-08 13
 * @describe : 订单物流查询
 */
@RestController
@RequestMapping("/order/sent/query")
public class SentQueryController {
    @Autowired
    private JdtcUtil jdtcUtil;
    @Autowired
    private IOrdersSentQueryService orderSentQueryService;

    @GetMapping
    public Object query(String sentNo){
        OrdersSentDto sent = orderSentQueryService.getSent(sentNo);
        Object sentInfo = null;
        if (sent.getTransport().equals("134")){
            sent.setTransportName("京东TC");
            sentInfo = jdTC(sent);
        }
        sent.setSentInfo(sentInfo);
        return sent;
    }



    public Object jdTC(OrdersSentDto sent){
        JSONArray traces = jdtcUtil.getOrderTrace(sent.getBjSentNo() + "-" + sent.getBjSentVersion());
        if (CollectionUtils.isEmpty(traces)){
            throw new ServiceException(ECode.JINGDONG_TC_ORDER_TRACE_ERROR);
        }
        return traces.get(0);
    }
}
