package com.sfa.job.pojo.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 财务同步旺店通接口-返回数据Dto
 */
@Data
public class SyncOrderDetailDto {
    private String method;
    private String remark;
    /**
     * 订单数量
     */
    private Integer orderCount;
    private Integer orderDetailCount;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;
    private Date latestTime;

    private Integer syncType;
    private String batchNo;
    private Integer pageNo;
    private Integer totalCount;
    /**
     * 错误信息
     */
    private String message;
    private Integer code = 200;

    public SyncOrderDetailDto setDetailInfo(String method, String remark, int syncType, int size, int mergerListSize, Integer totalCount, String batchNo, Date endTime, Date startTime) {
        // 接口测试使用
        this.setOrderCount(size);
        this.setOrderDetailCount(mergerListSize);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setLatestTime(endTime);
        this.setTotalCount(totalCount);
        this.setBatchNo(batchNo);
        this.setMethod(method);
         this.setSyncType(syncType);
        this.setRemark(remark);
        return this;
    }
}
