package com.sfa.job.domain.order.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 退换货订单数据
 * @author lvbencai
 * @date 2025-02-28 12:26:29
 */
@Data
@TableName(value = "wdt_swap_order")
public class WdtSwapOrder {
    /**
     * 换出订单原始单号
     */
    private String tid;

    /**
     * 店铺编号
     */
    private String shopNo;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * 仓库名称
     */
    private String warehouseNo;

    /**
     * 店铺id
     */
    private Integer shopId;

    /**
     * 仓库id
     */
    private Integer warehouseId;

    /**
     * 省份id
     */
    private Integer swapProvince;

    /**
     * 城市id
     */
    private Integer swapCity;

    /**
     * 地区
     */
    private String swapArea;

    /**
     * 地区id
     */
    private Integer swapDistrict;

    /**
     * 换货新订单物流公司id
     */
    private Integer swapLogisticsId;

    /**
     * 换货邮费
     */
    private BigDecimal postAmount;

    /**
     * 其他金额
     */
    private BigDecimal otherAmount;

    /**
     * 换出订单明细
     */
    private List<WdtSwapOrderDetail> swapOrderDetailList;
}
