package com.sfa.job.domain.system.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 三方系统回调事件日志
 * @TableName sys_event_log
 */
@TableName(value ="sys_event_log")
@Data
public class SysEventLog implements Serializable {
    /**
     * 事件日志ID
     */
    @TableId(type = IdType.AUTO)
    private Long eventLogId;

    /**
     * 事件名称
     */
    private String eventName;

    /**
     * 事件组名(飞书、勤策)
     */
    private String eventGroup;

    /**
     * 参数信息
     */
    private String requestMsg;

    /**
     * 返回信息
     */
    private String responseMsg;

    /**
     * 非0失败
     */
    private String fail;

    /**
     * 异常信息
     */
    private String exceptionInfo;

    /**
     * 创建时间
     */
    private Date createTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}