package com.sfa.job.domain.feishu.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * 勤策-区域销售人员架构表，来源：https://wangxiaolu.feishu.cn/sheets/I076slXhlhY2RdtDetEc17ornYd?sheet=49e4ba
 * @TableName qince_market_employee
 */
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@TableName(value ="qince_market_employee")
@Data
public class QinceMarketEmployee implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;


    /**
     * 经销商代码
     */
    private String dealerCode;
    private String dealerName;

    /**
     * 大区部门编码
     */
    private String dqDeptCode;

    /**
     * 战区部门编码
     */
    private String zqDeptCode;

    /**
     * 大区总工号
     */
    private String dqEmpNo;

    /**
     * 战区经理工号
     */
    private String zqEmpNo;

    /**
     * 城市经理工号
     */
    private String csEmpNo;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;
    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    public QinceMarketEmployee(String dealerCode, String dealerName, String dqDeptCode, String zqDeptCode, String dqEmpNo, String zqEmpNo, String csEmpNo) {
        this.dealerCode = dealerCode;
        this.dealerName = dealerName;
        this.dqDeptCode = dqDeptCode;
        this.zqDeptCode = zqDeptCode;
        this.dqEmpNo = dqEmpNo;
        this.zqEmpNo = zqEmpNo;
        this.csEmpNo = csEmpNo;
    }
}