package com.sfa.job.controller.order;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.ServiceException;
import com.sfa.common.redis.service.RedisService;
import com.sfa.job.constants.RedisKeyJob;
import com.sfa.job.pojo.response.OrderSentInfoResponse;
import com.sfa.job.pojo.response.OrdersSentDto;
import com.sfa.job.service.order.IOrdersSentQueryService;
import com.sfa.job.util.JdtcUtil;
import com.sfa.job.util.KyeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;


/**
 * @author : liqiulin
 * @date : 2025-07-08 13
 * @describe : 订单 - 发货单物流查询
 */
@RestController
@RequestMapping("/sent")
public class SentQueryController {
    @Autowired
    private JdtcUtil jdtcUtil;
    @Autowired
    private KyeUtil kyeUtil;
    @Autowired
    private IOrdersSentQueryService orderSentQueryService;
    @Autowired
    private RedisService redisService;

    @GetMapping("/query_p")
    public Object query(String sentNo){
        // 限制单号每小时只能查询5次
        String rKey = RedisKeyJob.QINCE_ORDER_SENT_INTERNET_COUNT + sentNo;
        Object cacheObject = redisService.getCacheObject(rKey);
        if (cacheObject != null && Integer.parseInt(cacheObject.toString()) >= 5) {
            throw new ServiceException(ECode.SENT_NO_QUERY_COUNT_ERROR);
        }
        Object sent = queryBySentNode(sentNo);
        redisService.setCacheObject(rKey, cacheObject == null ? 1 : Integer.parseInt(cacheObject.toString()) + 1,1L, TimeUnit.HOURS);
        return sent;
    }

    private Object queryBySentNode(String sentNo){
        OrdersSentDto sent = orderSentQueryService.getSent(sentNo);
        List<OrderSentInfoResponse> sentInfo = null;
        switch (sent.getTransport()) {
            case "134":
                sentInfo = jdTC134(sent);
                break;
            case "109":
                sentInfo = kye109(sent);
                break;
            default:
                throw new ServiceException(ECode.SENT_ISNULL_ERROR);
        }
        sent.setSentInfo(sentInfo);
        return sent;
    }

    private List<OrderSentInfoResponse> kye109(OrdersSentDto sent) {
        JSONArray traces = kyeUtil.getOrderTrace(sent.getExpressNo());
        if (CollectionUtils.isEmpty(traces)){
            return null;
        }
        JSONArray exteriorRouteList = traces.getJSONObject(0).getJSONArray("exteriorRouteList");
        return pKye109(exteriorRouteList);
    }

    private List<OrderSentInfoResponse> jdTC134(OrdersSentDto sent){
        JSONArray traces = jdtcUtil.getOrderTrace(sent.getBjSentNo() + "-" + sent.getBjSentVersion());
        JSONObject jb = traces.getJSONObject(0);
        return pJdTC134(jb.getJSONArray("traceDetails"));
    }

    private List<OrderSentInfoResponse> pJdTC134(JSONArray exteriorRouteList){
        List<OrderSentInfoResponse> sentInfoList = new ArrayList<>();
        exteriorRouteList.forEach(exteriorRoute -> {
            JSONObject exteriorRouteJson = (JSONObject) exteriorRoute;
            OrderSentInfoResponse sentInfo = new OrderSentInfoResponse();
            sentInfo.setOperateTime(exteriorRouteJson.getString("operateTime"));
            sentInfo.setOperateRemark(exteriorRouteJson.getString("operateRemark"));
            sentInfoList.add(sentInfo);
        });
        return sentInfoList;
    }

    private List<OrderSentInfoResponse> pKye109(JSONArray exteriorRouteList){
        List<OrderSentInfoResponse> sentInfoList = new ArrayList<>();
        exteriorRouteList.forEach(exteriorRoute -> {
            JSONObject exteriorRouteJson = (JSONObject) exteriorRoute;
            OrderSentInfoResponse sentInfo = new OrderSentInfoResponse();
            sentInfo.setOperateTime(exteriorRouteJson.getString("uploadDate"));
            sentInfo.setOperateRemark(exteriorRouteJson.getString("routeDescription"));
            sentInfoList.add(sentInfo);
        });
        return sentInfoList;
    }
}
