package com.sfa.job.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.job.domain.SysJobLog;
import com.sfa.job.mapper.SysJobLogMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 定时任务调度日志信息 服务层
 *
 * @author ruoyi
 */
@Service
public class SysJobLogServiceImpl implements ISysJobLogService
{
    @Autowired
    private SysJobLogMapper jobLogMapper;

    /**
     * 获取quartz调度器日志的计划任务
     *
     * @param jobLog 调度日志信息
     * @return 调度任务日志集合
     */
    @Override
    public PageInfo selectJobLogList(SysJobLog jobLog)
    {
        LambdaQueryWrapper<SysJobLog> qw = buildWrapper(jobLog);
        Page<SysJobLog> pageR = jobLogMapper.selectPage(TableSupport.pageI(), qw);
        PageInfo<SysJobLog> pageInfo = new PageInfo<>(pageR);
        return pageInfo;
    }

    private LambdaQueryWrapper<SysJobLog> buildWrapper(SysJobLog jobLog) {
        LambdaQueryWrapper<SysJobLog> qw = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(jobLog.getStatus())){
            qw.eq(SysJobLog::getStatus,jobLog.getStatus());
        }
        if (StringUtils.isNotBlank(jobLog.getJobGroup())){
            qw.eq(SysJobLog::getJobGroup,jobLog.getJobGroup());
        }
        if (StringUtils.isNotBlank(jobLog.getJobName())){
            qw.like(SysJobLog::getJobName,jobLog.getJobName());
        }
        if (StringUtils.isNotBlank(jobLog.getInvokeTarget())){
            qw.like(SysJobLog::getInvokeTarget,jobLog.getInvokeTarget());
        }
        if (Objects.nonNull(jobLog.getBeginTime())&&Objects.nonNull(jobLog.getEndTime())){
            qw.between(SysJobLog::getCreateTime, jobLog.getBeginTime(),jobLog.getEndTime());
        }
        qw.orderByDesc(SysJobLog::getCreateTime);
        return qw;
    }

    /**
     * 通过调度任务日志ID查询调度信息
     *
     * @param jobLogId 调度任务日志ID
     * @return 调度任务日志对象信息
     */
    @Override
    public SysJobLog selectJobLogById(Long jobLogId)
    {
        return jobLogMapper.selectJobLogById(jobLogId);
    }

    /**
     * 新增任务日志
     *
     * @param jobLog 调度日志信息
     */
    @Override
    public void addJobLog(SysJobLog jobLog)
    {
        jobLogMapper.insertJobLog(jobLog);
    }

    /**
     * 批量删除调度日志信息
     * 
     * @param logIds 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteJobLogByIds(Long[] logIds)
    {
        return jobLogMapper.deleteJobLogByIds(logIds);
    }

    /**
     * 删除任务日志
     * 
     * @param jobId 调度日志ID
     */
    @Override
    public int deleteJobLogById(Long jobId)
    {
        return jobLogMapper.deleteJobLogById(jobId);
    }

    /**
     * 清空任务日志
     */
    @Override
    public void cleanJobLog()
    {
        jobLogMapper.cleanJobLog();
    }
}
