package com.sfa.job.domain.qince.dao;

import cn.hutool.core.date.DateUtil;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.job.domain.qince.entity.QinceDealer;
import com.sfa.job.domain.qince.mapper.QinceDealerMapper;
import com.sfa.job.pojo.qince.response.QinceDealerDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-04-24 15
 * @describe :
 */
@DS("promotion")
@Service
public class QinceDealerDaoImpl implements IQinceDealerDao{

    @Autowired
    private QinceDealerMapper qinceDealerMapper;

    @Override
    public List<QinceDealerDto> getPushQinceDealers() {
        String today = DateUtil.today();
        List<QinceDealer> qinceDealers = qinceDealerMapper.pushQinceDealers(today);
        return BeanUtils.transitionDtos(qinceDealers, QinceDealerDto.class);
    }
}
