package com.sfa.job.xxljob.qince;

import com.sfa.job.service.qince.IQinceDealerQueryService;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author : liqiulin
 * @date : 2025-04-24 17
 * @describe :
 */
@Component
@Slf4j
public class QinceCoreTask {
    @Autowired
    private IQinceDealerQueryService qinceCoreService;

    @XxlJob("qince_modify_dealer")
    public void qinceCoreTask() {
        log.info("回写勤策经销商大区、战区信息 start");
        qinceCoreService.updateQinceDealerInfo();
        log.info("回写勤策经销商大区、战区信息 end");
    }

    public void qinceCoreStore(){
        log.info("回写勤策门店城市经理、战区经理、大区总监 start");
        qinceCoreService.updateQinceStore();
        log.info("回写勤策门店城市经理、战区经理、大区总监 end");
    }


    @XxlJob("qince_cus_visit_record")
    public void queryCusVisitRecord() {
        log.info("查询勤策客户拜访记录 start");
        qinceCoreService.queryCusVisitRecord();
        log.info("查询勤策客户拜访记录 start");
    }
}
