package com.sfa.job.util;

import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.google.gson.JsonParser;
import com.lark.oapi.Client;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.service.contact.v3.enums.ChildrenDepartmentDepartmentIdTypeEnum;
import com.lark.oapi.service.contact.v3.enums.FindByDepartmentUserDepartmentIdTypeEnum;
import com.lark.oapi.service.contact.v3.enums.FindByDepartmentUserUserIdTypeEnum;
import com.lark.oapi.service.contact.v3.model.ChildrenDepartmentReq;
import com.lark.oapi.service.contact.v3.model.ChildrenDepartmentResp;
import com.lark.oapi.service.contact.v3.model.FindByDepartmentUserReq;
import com.lark.oapi.service.contact.v3.model.FindByDepartmentUserResp;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-12-06 16
 * @describe :
 */
@Slf4j
@Component
public class FeiShuUtil {

    @Value("${feishu.luzx.app_id}")
    private String appId;
    @Value("${feishu.luzx.app_secret}")
    private String appSecret;

    @Value("${feishu.bot_1.app_id}")
    private String botAppId1;
    @Value("${feishu.bot_1.app_secret}")
    private String botAppSecret1;


    private static final String CONTENT_TYPE = "application/json; charset=utf-8";
    private static final String SHEET_URL = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/";
    private static final String TENANT_ACCESS_TOKEN_URL = "https://open.feishu.cn/open-apis/auth/v3/tenant_access_token/internal";
    private static final String VALUES_APPEND = "/values_append";
    private static final String VALUES_IMAGE = "/values_image";
    private static final String VALUES_BATCH_GET = "/values_batch_get";
    private static final String VALUES = "/values";
    private static final String STYLE = "/style";


    /**
     * 根据部门父编码获取子部门
     * 公司编码："0"
     */
    public JSONArray getDeptByParentId(String parentId) {
        try {
            Client client = getClient();
            ChildrenDepartmentReq req = ChildrenDepartmentReq.newBuilder()
                    .departmentId(parentId)
                    .departmentIdType(ChildrenDepartmentDepartmentIdTypeEnum.DEPARTMENT_ID)
                    .pageSize(50)
                    .build();
            ChildrenDepartmentResp resp = client.contact().department().children(req);
            if (!resp.success()) {
                log.error(String.format("code:%s,msg:%s,reqId:%s, resp:%s",
                        resp.getCode(), resp.getMsg(), resp.getRequestId(), Jsons.createGSON(true, false).toJson(JsonParser.parseString(new String(resp.getRawResponse().getBody(), "UTF-8")))));
                return null;
            }
            JSONArray items = JSONObject.parse(Jsons.DEFAULT.toJson(resp.getData())).getJSONArray("items");
            return items;
        } catch (Exception e) {
            log.error("获取子部门列表失败，停止执行！");
        }
        return null;
    }

    /**
     * 获取部门用户
     */
    public JSONArray getUsersByDeptId(String deptCode) {
        try {
            Client client = getClient();
            FindByDepartmentUserReq req = FindByDepartmentUserReq.newBuilder()
                    .userIdType(FindByDepartmentUserUserIdTypeEnum.OPEN_ID)
                    .departmentIdType(FindByDepartmentUserDepartmentIdTypeEnum.DEPARTMENT_ID)
                    .departmentId(deptCode)
                    .pageSize(50)
                    .build();
            FindByDepartmentUserResp resp = client.contact().user().findByDepartment(req);
            if(!resp.success()) {
                log.warn(String.format("code:%s,msg:%s,reqId:%s, resp:%s",
                        resp.getCode(), resp.getMsg(), resp.getRequestId(), Jsons.createGSON(true, false).toJson(JsonParser.parseString(new String(resp.getRawResponse().getBody(), "UTF-8")))));
                return null;
            }
            JSONArray items = JSONObject.parse(Jsons.DEFAULT.toJson(resp.getData())).getJSONArray("items");
            return items;
        } catch (Exception e) {
            log.error("获取部门用户失败，停止执行！部门id：{}", deptCode);
        }
        return null;
    }

    /**
     * 获取表格数据
     */
    public JSONArray pullSheet(String sheetToken, String autoToken, String ranges) {
        try {
            Map<String, Object> params = new HashMap<>();
            params.put("ranges", ranges);
            String result = HttpUtil.createGet(SHEET_URL + sheetToken + VALUES_BATCH_GET).form(params).auth("Bearer " + autoToken).contentType(CONTENT_TYPE).execute().body();
            JSONObject resultJson = JSONObject.parseObject(result);
            System.out.println(resultJson);
            int code = resultJson.getInteger("code");
            if (code != 0) {
                throw new RuntimeException("获取飞书表格范围数据错误："+resultJson.getString("msg"));
            }
            return resultJson.getJSONObject("data").getJSONArray("valueRanges");
        }catch (Exception e) {
            log.error("拉取表格数据失败，停止执行！", e);
        }
        return new JSONArray();
    }

    private Client getClient() {
        return Client.newBuilder(appId, appSecret).build();
    }

    public Integer pushSetToSheet(String range, List<Object> datas, String sheetToken, String autoToken) {
        // 组装参数
        Map<String, Map<String, Object>> bodyMap = new HashMap<>();
        Map<String, Object> valueRange = new HashMap<>();
        valueRange.put("range", range);
        valueRange.put("values", datas);
        bodyMap.put("valueRange", valueRange);
        String bodyJson = JSONObject.toJSONString(bodyMap);

        // body上传
        String result = HttpUtil.createPost(SHEET_URL + sheetToken + VALUES_APPEND)
                .auth("Bearer " + autoToken).contentType(CONTENT_TYPE)
                .body(bodyJson)
                .execute().body();

        // 上传结果判断
        JSONObject resultJson = JSONObject.parseObject(result);
        return resultJson.getInteger("code");
    }


    public String getBotToken1() {
        Map<String, Object> bodyMap = new HashMap<>();
        bodyMap.put("app_id", botAppId1);
        bodyMap.put("app_secret", botAppSecret1);
        String bodyJson = JSONObject.toJSONString(bodyMap);

        String result = HttpUtil.createPost(TENANT_ACCESS_TOKEN_URL)
                .contentType(CONTENT_TYPE)
                .body(bodyJson)
                .execute().body();

        JSONObject resultJson = JSONObject.parseObject(result);
        int code = resultJson.getInteger("code");
        if (code != 0) {
            throw new RuntimeException("获取tenant_access_token错误");
        }
        return resultJson.getString("tenant_access_token");
    }

    public void appendStyle(String sheetToken, Map<String, Object> body,String autoToken) {
        // body上传
        String result = HttpUtil.createRequest(Method.PUT,SHEET_URL + sheetToken + STYLE)
                .auth("Bearer " + autoToken).contentType(CONTENT_TYPE)
                .body(JSONObject.toJSONString(body))
                .execute().body();
    }

    public JSONObject pullSheetOneRange(String sheetToken, String botToken1, String ranges) {
        return pullSheet(sheetToken, botToken1, ranges).getJSONObject(0);
    }
}
