package com.sfa.job.domain.ls;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.domain.ls.mapper.LsDisStoreMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-11-27 17
 * @describe :
 */
@Slf4j
@DS("bi")
@Service
public class LsDisStoreDaoImpl {

    @Autowired
    private LsDisStoreMapper lsDisStoreMapper;

//    安徽王小卤主体
    public void baiduAddressAnHui(Long ldsId){
        List<LsDisStore> lsDisStores = lsDisStoreMapper.selectBaseO(ldsId);
        if (lsDisStores.isEmpty()){
            return;
        }
        ldsId = lsDisStores.get(lsDisStores.size() - 1).getLdsIf();
        updateanhui(lsDisStores,ldsId);
    }

    private void updateanhui(List<LsDisStore> lsDisStores,Long ldsId){
        for (LsDisStore lsDisStore : lsDisStores) {
            String outlet = lsDisStore.getOutletName()+lsDisStore.getOutletAddress();
            String s = HttpUtil.get("https://api.map.baidu.com/geocoding/v3/?address="+outlet+"&output=json&ak=1ZKO0CGs6nm9HuZWR6ucRiu4p9kM8f3i&city="+lsDisStore.getReCity());
            JSONObject bd = JSONObject.parseObject(s);
            Integer status = bd.getInteger("status");
            if (status.intValue() >= 300 && status.intValue() <= 399){
                log.info(s);
                return;
            }
            if (status.intValue() != 0){
                continue;
            }
            JSONObject jo = bd.getJSONObject("result");
            String analysLevel = jo.getString("level");
            lsDisStore.setLat(analysLevel);
            if (!analysLevel.equals("省") && !analysLevel.equals("城市")){
                JSONObject location = jo.getJSONObject("location");
                Float lng = location.getFloat("lng");
                Float lat = location.getFloat("lat");
                lsDisStore.setLng(lat+","+lng);
            }
        }
        lsDisStoreMapper.updateListO(lsDisStores);
        baiduAddressAnHui(ldsId);
    }

    //    广州王小卤主体
    public void baiduAddressGuangzhou(long ldsId) {
        List<LsDisStore> lsDisStores = lsDisStoreMapper.selectBaseT(ldsId);
        if (lsDisStores.isEmpty()){
            return;
        }
        ldsId = lsDisStores.get(lsDisStores.size() - 1).getLdsIf();
        updateGuangzhou(lsDisStores,ldsId);
    }


    private void updateGuangzhou(List<LsDisStore> lsDisStores,Long ldsId){
        for (LsDisStore lsDisStore : lsDisStores) {
            String outlet = lsDisStore.getOutletName()+lsDisStore.getOutletAddress();
            String s = HttpUtil.get("https://api.map.baidu.com/geocoding/v3/?address="+outlet+"&output=json&ak=8ptRbXOnQNX2TTqGVVYv5AUw3vJZ77gZ&city="+lsDisStore.getReCity());
            JSONObject bd = JSONObject.parseObject(s);
            Integer status = bd.getInteger("status");
            if (status.intValue() >= 300 && status.intValue() <= 399){
                log.info(s);
                return;
            }
            if (status.intValue() != 0){
                continue;
            }
            JSONObject jo = bd.getJSONObject("result");
            String analysLevel = jo.getString("level");
            lsDisStore.setLat(analysLevel);
            if (!analysLevel.equals("省") && !analysLevel.equals("城市")){
                JSONObject location = jo.getJSONObject("location");
                Float lng = location.getFloat("lng");
                Float lat = location.getFloat("lat");
                lsDisStore.setLng(lat+","+lng);
            }
        }
        lsDisStoreMapper.updateListT(lsDisStores);
        baiduAddressGuangzhou(ldsId);
    }


    public void baiduAddressAnHuisp(Long ldsId){
        List<LsDisStore> lsDisStores = lsDisStoreMapper.selectBaseS(ldsId);
        if (lsDisStores.isEmpty()){
            return;
        }
        ldsId = lsDisStores.get(lsDisStores.size() - 1).getLdsIf();
        updateanhuisp(lsDisStores,ldsId);
    }

    private void updateanhuisp(List<LsDisStore> lsDisStores,Long ldsId){
        for (LsDisStore lsDisStore : lsDisStores) {
            String outlet = lsDisStore.getOutletName()+lsDisStore.getOutletAddress();
            String s = HttpUtil.get("https://api.map.baidu.com/geocoding/v3/?address="+outlet+"&output=json&ak=StY6BS8Bw50TrclA4Zd52MfEjsL1zUXI&city="+lsDisStore.getReCity());
            JSONObject bd = JSONObject.parseObject(s);
            Integer status = bd.getInteger("status");
            if (status.intValue() >= 300 && status.intValue() <= 399){
                log.info(s);
                return;
            }
            if (status.intValue() != 0){
                continue;
            }
            JSONObject jo = bd.getJSONObject("result");
            String analysLevel = jo.getString("level");
            lsDisStore.setLat(analysLevel);
            if (!analysLevel.equals("省") && !analysLevel.equals("城市")){
                JSONObject location = jo.getJSONObject("location");
                Float lng = location.getFloat("lng");
                Float lat = location.getFloat("lat");
                lsDisStore.setLng(lat+","+lng);
            }
        }
        lsDisStoreMapper.updateListS(lsDisStores);
        baiduAddressAnHuisp(ldsId);
    }

}
