package com.sfa.job.service.erp.impl;

import com.alibaba.fastjson2.JSONObject;
import com.sfa.common.core.utils.DateUtils;
import com.sfa.job.domain.erp.dao.ErpAxmr005ShippingDetailsDao;
import com.sfa.job.pojo.response.FeishuSheetRecordDto;
import com.sfa.job.service.erp.ErpAxmr005Service;
import com.sfa.job.util.FeiShuUtil;
import com.sfa.job.domain.use.dao.FeishuSheetRecordDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-04-08 13
 * @describe :
 */
@Service
public class ErpAxmr005ServiceImpl implements ErpAxmr005Service {
    @Autowired
    private ErpAxmr005ShippingDetailsDao erpAxmr005ShippingDetailsDao;
    @Autowired
    private FeishuSheetRecordDao feishuSheetRecordDao;
    @Autowired
    private FeiShuUtil feiShuUtil;


    @Override
    public void axmr005ZQToFS(Date debitDate,Integer type) {
        List<Object> zhanquDataset = erpAxmr005ShippingDetailsDao.getZhanquDataset(debitDate);
        FeishuSheetRecordDto recordDto = feishuSheetRecordDao.selectOne(type, DateUtils.parseDateToStr(DateUtils.YYYY_MM, debitDate));

        /**
         * 将结果推送到飞书表格，每次推100条
         */
        String range = recordDto.getSheetId() + "!A:H";
        JSONObject botToken1 = feiShuUtil.getBotToken1();

        int batchSize = 100;
        for (int i = 0; i < zhanquDataset.size(); i+=batchSize) {
            // 计算当前批次的结束位置
            int end = Math.min(i + batchSize, zhanquDataset.size());
            System.out.println(end);
            List<Object> batch = zhanquDataset.subList(i, end);
            feiShuUtil.pushSetToSheet(range,batch,recordDto.getSheetToken(),botToken1.getString("tenant_access_token"));
        }

    }
}
