package com.sfa.job.xxljob.order;

import cn.hutool.core.date.DateUtil;
import com.sfa.job.pojo.response.FinanceSyncOrderDetailDto;
import com.sfa.job.service.order.FinanceOrderSyncService;
import com.xxl.job.core.context.XxlJobContext;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author : 吕本才
 * @date : 2025-01-15 13:03:51
 * @describe : 财务订单数据
 */
@Component
@Slf4j
public class FinanceOrderTask {

    @Autowired
    FinanceOrderSyncService  financeOrderSyncService;

    /**
     * 同步部门数据
     */
    @XxlJob("syncWangdiantongOrderDetail")
    public FinanceSyncOrderDetailDto syncWangdiantongOrderDetail() {
        Long st = System.currentTimeMillis();
        // 暂不考虑分片
        XxlJobContext xxlJobContext = XxlJobContext.getXxlJobContext();
        int shardingTotalCount = xxlJobContext.getShardTotal();
        int shardingItem = xxlJobContext.getShardIndex();
        XxlJobHelper.log(">>>>>>>>>>syncWangdiantongOrderDetail Job start<<<<<<<<<<");

        // 简单模拟分片处理，这里输出每个分片的信息
        XxlJobHelper.log("分片总数: " + shardingTotalCount + ", 当前分片: " + shardingItem);
        XxlJobHelper.log("xxl-job开始同步-旺店通订单明细api接口数据");

        // 定时任务不设定开始时间和结束时间
        FinanceSyncOrderDetailDto detailDto = financeOrderSyncService.syncWangdiantongOrder(null, null,0);

        XxlJobHelper.log("xxl-job结束同步-旺店通订单明细api接口数据, 共同步订单{}条数据，订单明细{}条,订单批次号：{},订单的开始时间{}和结束时间{}",
                detailDto.getOrderCount(),detailDto.getOrderDetailCount(),detailDto.getBatchNo(),
                DateUtil.formatDateTime(detailDto.getStartTime()),DateUtil.formatDateTime(detailDto.getEndTime()) );
        return detailDto;
    }

}
