package com.sfa.job.consumer.feishu;

import com.alibaba.fastjson2.JSONObject;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.enums.promotion.PlanStatus;
import com.sfa.common.core.exception.ServiceException;
import com.sfa.job.constants.Constants;
import com.sfa.job.pojo.feishu.event.EventCallBackDto;
import com.sfa.job.service.feishu.IEventCallbackService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;

/**
 * @author : liqiulin
 * @date : 2025-06-04 13
 * @describe : 飞书事件订阅 - 来自应用【王小卤链路中心】
 * 订阅方式：https://open.feishu.cn/api-explorer/cli_a7dbe3ec7d9e5013?apiName=subscribe&from=op_doc_tab&project=approval&resource=approval&version=v4
 */
@Slf4j
@RestController
@RequestMapping("/event_callback/fs/luzx")
public class EventCallbackLuzx {
    @Value("${feishu.luzx.encrypt_key}")
    private String encryptKeyP;
    @Value("${feishu.approval.scfy}")
    private String scfyCode;
    @Autowired
    private IEventCallbackService eventCallbackService;

    @RequestMapping(method = RequestMethod.POST)
    public JSONObject handleEvent(@RequestBody JSONObject eventObj) {
        String encryptKey = encryptKeyP;
        String encrypt = eventObj.getString(Constants.ENCRYPT);

        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] keyBs = digest.digest(encryptKey.getBytes(StandardCharsets.UTF_8));
            String decrypt = decrypt(encrypt,keyBs);
            JSONObject req = JSONObject.parseObject(decrypt);
            log.info("飞书事件订阅 - 解密数据：{}",req);

            EventCallBackDto eventCallBackDto = JSONObject.parseObject(decrypt, EventCallBackDto.class);
            EventCallBackDto.Event event = eventCallBackDto.getEvent();
            /**
             * 订阅审批 - 市场推广费用申请（审批实例CODE：258B4D93-96D4-49E4-B9E1-DA6AB45740B0）
             */
            if (Constants.FEISHU_APPROVAL_INSTANCE.equals(event.getType()) && scfyCode.equals(event.getApprovalCode())){
                if (!event.getStatus().equals(PlanStatus.PENDING.name())){
                    eventCallbackService.planCP(event);
                }
            }
            return req;
        } catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException(ECode.DB_TABLE_UPDATE_ERROR.getMsg(),ECode.DB_TABLE_UPDATE_ERROR.getCode());
        }
    }

    /**
     * 解析encrypt_key加密数据
     */
    private String decrypt(String base64,byte[] keyBs) throws Exception {
        byte[] decode = Base64.getDecoder().decode(base64);
        Cipher cipher = Cipher.getInstance("AES/CBC/NOPADDING");
        byte[] iv = new byte[16];
        System.arraycopy(decode, 0, iv, 0, 16);
        byte[] data = new byte[decode.length - 16];
        System.arraycopy(decode, 16, data, 0, data.length);
        cipher.init(Cipher.DECRYPT_MODE, new SecretKeySpec(keyBs, "AES"), new IvParameterSpec(iv));
        byte[] r = cipher.doFinal(data);
        if (r.length > 0) {
            int p = r.length - 1;
            for (; p >= 0 && r[p] <= 16; p--) {
            }
            if (p != r.length - 1) {
                byte[] rr = new byte[p + 1];
                System.arraycopy(r, 0, rr, 0, p + 1);
                r = rr;
            }
        }
        return new String(r, StandardCharsets.UTF_8);
    }


}
