package com.sfa.job.xxljob.test;

import com.sfa.job.domain.ls.LsDisStoreDaoImpl;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author : liqiulin
 * @date : 2025-04-08 13
 * @describe :
 */
@Component
@Slf4j
public class TestTask {

    @Autowired
    private LsDisStoreDaoImpl lsDisStoreDaoImpl;

    @XxlJob("ls_store_anhui")
    public void lsStoreAnHui() {
        lsDisStoreDaoImpl.baiduAddressAnHui(0L);
    }

    @XxlJob("ls_store_guangzhou")
    public void lsStoreGuangzhou() {
        lsDisStoreDaoImpl.baiduAddressGuangzhou(500000L);
    }


    @XxlJob("ls_store_ahsp")
    public void lsStoreAnHuisp() {
        lsDisStoreDaoImpl.baiduAddressAnHuisp(1000000L);
    }

    /**
     * 逆地理编码
     */
    @XxlJob("ls_store_n_anhui")
    public void lsStoreNAnHui() {
        lsDisStoreDaoImpl.nAddreasAnHui(0L);
    }
    @XxlJob("ls_store_n_xy")
    public void lsStoreNXY() {
        lsDisStoreDaoImpl.lsStoreNXY(250000L);
    }
    @XxlJob("ls_store_n_gh")
    public void lsStoreNGH() {
        lsDisStoreDaoImpl.lsStoreNGH(500000L);
    }

    @XxlJob("ls_store_n_hs")
    public void lsStoreNHS() {
        lsDisStoreDaoImpl.lsStoreNHS(750000L);
    }

    @XxlJob("ls_store_n_dx")
    public void lsStoreNDX() {
        lsDisStoreDaoImpl.lsStoreNDX(1000000L);
    }

    @XxlJob("ls_store_n_ql")
    public void lsStoreNQL() {
        lsDisStoreDaoImpl.lsStoreNQL(1250000L);
    }

}
