package com.sfa.job.xxljob.order;

import com.sfa.job.service.order.IOrdersSentQueryService;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author : liqiulin
 * @date : 2025-07-10 16
 * @describe : 勤策订单
 */
@Component
public class OrdersSentToQince {

    @Autowired
    private IOrdersSentQueryService ordersSentService;

    /**
     * 推送勤策发货单轨迹/物流承运商
     */
    @XxlJob("push_qc_order_sent")
    public void ordersSentToQince(){
        ordersSentService.ordersSentToQince();
    }

    /**
     * 查询发货单回单情况
     */
    @XxlJob("get_order_sent_receipt")
    public void getSentReceipt(){
        ordersSentService.getOrderSentReceipt();
    }


}
