package com.sfa.job.service.zzcenter.impl;


import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.domain.zzcenter.dao.IZzProductQualityDao;
import com.sfa.job.pojo.zzcenter.ZzProductQualityDto;
import com.sfa.job.service.zzcenter.IZzProQualityService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * @Author: DouXinYu
 * @Date: 2026-02-05 17:59
 * @Description: 质检服务实现类
 */

@Service
@Slf4j
@DS("bi")
public class ZzProQualityServiceImpl implements IZzProQualityService {
    @Autowired
    IZzProductQualityDao zzProductQualityDao;

    @Override
    public List<ZzProductQualityDto> queryNotSyncList(Integer status) {
        return zzProductQualityDao.selectListBySyncStatus(status);
    }

    @Override
    public Integer updateSyncStatus(ZzProductQualityDto zzProductQualityDto) {
        return zzProductQualityDao.updateSyncStatus(zzProductQualityDto);
    }
}
