package com.sfa.job.service.feishu;

import com.alibaba.fastjson2.JSONObject;
import com.lark.oapi.service.vc.v1.model.MeetingSecuritySetting;
import com.sfa.common.core.utils.DateUtils;
import com.lark.oapi.service.corehr.v1.model.Offboarding;
import com.lark.oapi.service.corehr.v2.model.*;
import com.sfa.common.core.enums.promotion.PlanStatus;
import com.sfa.common.core.utils.sdk.FeiShuUtil;
import com.sfa.common.core.utils.sdk.FeiShuUtils;
import com.sfa.job.domain.promotion.dao.IActivityPlanDao;
import com.sfa.job.domain.system.dao.ISysDeptDao;
import com.sfa.job.domain.system.dao.ISysEventLogDao;
import com.sfa.job.domain.system.dao.ISysUserDao;
import com.sfa.job.pojo.feishu.event.EventCallBackDto;
import com.sfa.job.pojo.promotion.response.ActivityPlanApprovalDto;
import com.sfa.job.pojo.response.SysEventLogDto;
import com.sfa.job.service.system.IDeptAndUserService;
import com.sfa.job.util.QinCeUtils;
import com.sfa.job.util.T100Util;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-06-04 17
 * @describe :
 */
@Slf4j
@Service
public class EventCallbackServiceImpl implements IEventCallbackService{
    @Autowired
    private IActivityPlanDao activityPlanDao;
    @Autowired
    private ISysUserDao sysUserDao;
    @Autowired
    private ISysDeptDao sysDeptDao;
    @Autowired
    private ISysEventLogDao sysEventLogDao;
    @Autowired
    private IDeptAndUserService deptAndUserService;
    @Autowired
    private FeiShuUtil feiShuUtil;
    @Autowired
    private T100Util t100Util;
    @Autowired
    private QinCeUtils qinCeUtils;


    @Override
    public void planCP(EventCallBackDto.Event event) {
        String status = event.getStatus();
        String instanceId = event.getFsInstanceId();
        ActivityPlanApprovalDto planApproval = activityPlanDao.findPlanApproval(instanceId);
        if (planApproval == null){
            log.error("审批实例不存在：{}",event);
        }

        activityPlanDao.updateApprovalStatusById(planApproval.getId(),status);

        // 校验状态：已通过=已通过；非已通过=审批未通过
        PlanStatus planStatus = PlanStatus.APPROVED.name().equals(status) ? PlanStatus.NOT_EXECUTION : PlanStatus.REJECTED;
        Integer planStatusCode = planStatus.getCode();

        activityPlanDao.updateActivityPlanStatusByInstanceId(instanceId,planStatusCode);
    }

    @Override
    public void deptCreate(String departmentId) {
        JSONObject deptT100 = new JSONObject();
        Department dept = feiShuUtil.getDepartmentCorehr(departmentId);
        String deptCode = dept.getCode();
        String deptName = dept.getDepartmentName()[0].getValue();
        customFields(dept.getCustomFields(),deptT100);

        String parentDepartmentId = dept.getParentDepartmentId();
        Department parentdept = feiShuUtil.getDepartmentCorehr(parentDepartmentId);
        deptT100.put("top_level_department_no", Objects.nonNull(parentdept.getIsRoot()) && parentdept.getIsRoot() ? "BJHQ" : parentdept.getCode());

        if (Objects.nonNull(parentdept.getIsRoot()) && parentdept.getIsRoot()){
            deptT100.put("ooeg004",deptCode);
        }else {
            // 获取上级部门树、从而获取1级部门
            DepartmentParentInfo[] parentsDept = feiShuUtil.getParentsDepartmentReq(dept.getId());
            DepartmentParentInfo deptL1 = parentsDept[parentsDept.length - 2];

            // 获取1级部门编码
            Department deptInfoL1 = feiShuUtil.getDepartmentCorehr(deptL1.getDepartmentId());
            String deptCodeL1 = deptInfoL1.getCode();
            deptT100.put("ooeg004",deptCodeL1);
        }

        deptT100.put("data_status","A");
        deptT100.put("status","Y");
        deptT100.put("department_no",deptCode);
        deptT100.put("effective_date", "2024/05/01");
        deptT100.put("expiration_date",null);
        deptT100.put("corporation","ALL");
        deptT100.put("department_name_name",deptName);
        deptT100.put("department_shortname",deptName);
        deptT100.put("top_organization_no","ALL");
        deptT100.put("department_heads_employee_no","");
        deptT100.put("ooeg005","Y");
        String msg = createOrUpdateDept(deptT100);
        SysEventLogDto eventDto = new SysEventLogDto()
                .setEventName("T100 dept A")
                .setEventGroup("T100 dept")
                .setRequestMsg(JSONObject.toJSONString(deptT100))
                .setResponseMsg(msg);
        sysEventLogDao.insert(eventDto);
    }

    @Override
    public void deptUpdate(String departmentId) {
        JSONObject deptT100 = new JSONObject();
        Department dept = feiShuUtil.getDepartmentCorehr(departmentId);
        // 部门启用状态，true为启用，false为停用
        Boolean active = dept.getActive();

        String deptCode = dept.getCode();
        I18n[] departmentName = dept.getDepartmentName();
        String deptName = active ? departmentName[0].getValue() : "（失效）"+departmentName[0].getValue();

        customFields(dept.getCustomFields(),deptT100);

        String parentDepartmentId = dept.getParentDepartmentId();
        Department parentdept = feiShuUtil.getDepartmentCorehr(parentDepartmentId);

        if (Objects.nonNull(parentdept.getIsRoot()) && parentdept.getIsRoot()){
            deptT100.put("ooeg004",deptCode);
        }else {
            // 获取上级部门树、从而获取1级部门
            DepartmentParentInfo[] parentsDept = feiShuUtil.getParentsDepartmentReq(dept.getId());
            DepartmentParentInfo deptL1 = parentsDept[parentsDept.length - 2];

            // 获取1级部门编码
            Department deptInfoL1 = feiShuUtil.getDepartmentCorehr(deptL1.getDepartmentId());
            String deptCodeL1 = deptInfoL1.getCode();
            deptT100.put("ooeg004",deptCodeL1);
        }

        deptT100.put("data_status","AU");
        deptT100.put("status","Y");
        deptT100.put("department_no",deptCode);
        // 上级部门
        deptT100.put("top_level_department_no", Objects.nonNull(parentdept.getIsRoot()) && parentdept.getIsRoot() ? "BJHQ" : parentdept.getCode());
        // 生效日期
        deptT100.put("effective_date", "2024/05/01");
        deptT100.put("expiration_date",null);
        // 限定使用法人
        deptT100.put("corporation","ALL");
        // 部门名称
        deptT100.put("department_name",deptName);
        deptT100.put("department_shortname",deptName);

        deptT100.put("top_organization_no","ALL");
        // 部门负责人
        deptT100.put("department_heads_employee_no","");
        // 会计部门
        deptT100.put("ooeg005","Y");
        String msg = createOrUpdateDept(deptT100);
        SysEventLogDto eventDto = new SysEventLogDto()
                .setEventName("T100 dept AU")
                .setEventGroup("T100 dept")
                .setRequestMsg(JSONObject.toJSONString(deptT100))
                .setResponseMsg(msg);
        sysEventLogDao.insert(eventDto);
        // 部门停用时，删除链路中心部门
        if (!active) {
            sysDeptDao.deleteDept(deptCode);
        }
    }

    /**
     * 员工入职
     */
    @Override
    public void userCreateOrUpdate(String employmentId) {
        Employee emp = feiShuUtil.getEmployeeReq(employmentId);
        userAUT100(emp);
    }

    /**
     * personId：创建人员信息时，生成的ID
     */
    @Override
    public void userUpdateByPersonId(String personId) {
        Employee emp = feiShuUtil.getPersonReq(personId);
        userAUT100(emp);
    }

    /**
     * 根据工号做员工离职
     */
    @Override
    public void userResigned(String employmentId) {
        // 根据employmentId查询离职信息，如果没有搜索到离职信息，则直接禁用
        Date offboardDate = null;
        Offboarding offboarding = feiShuUtil.searchOffboardings(employmentId);
        if (!Objects.isNull(offboarding)){
            String offboardingDate = offboarding.getOffboardingInfo().getOffboardingDate();
            offboardDate = DateUtils.parseDate(offboardingDate);
        }

        Employee emp = feiShuUtil.getEmployeeReq(employmentId);
        String employeeNo = emp.getEmployeeNumber();
        if (StringUtils.isEmpty(employeeNo)){
            return;
        }
        sysUserDao.updateOffboardDate(employeeNo,offboardDate);
        // 判定offboardDate 是否是以前
        if (!offboardDate.before(new Date())){
            return;
        }
        deptAndUserService.userResigned(employeeNo);
    }


    /**
     * 获取最小销售价自动设置勤策最小单元售价
     */
    @Override
    public void getMinimumSellingPrice(EventCallBackDto.Event event ,String approveTemplateCode) {
        String fsInstanceId = event.getFsInstanceId();
        String approvalInfo = feiShuUtil.getApprovalInfo(fsInstanceId);
        log.info("开始处理审批单：{}",fsInstanceId);
        log.info("审批单信息：{}",approvalInfo);
        if (StringUtils.isBlank(approvalInfo)){
            String errorMsg = "审批单" + fsInstanceId + "不存在，终止处理";
            log.error("审批单不存在：{}",fsInstanceId);
            // 调用封装的错误日志记录方法
            recordErrorLog("FeiShu sync QinCe Price ", "FeiShu sync", "fsInstanceId：" + fsInstanceId, errorMsg);
            return;
        }

        // 获取审批单字段ID
        Map<String, Object> fieldIdMap = feiShuUtil.getApprovalFormValues(approvalInfo);
        if (fieldIdMap.isEmpty()){
            String errorMsg = "获取审批单字段ID失败，终止处理";
            log.error("获取审批单字段ID失败：{}",approvalInfo);
            // 调用封装的错误日志记录方法
            recordErrorLog("FeiShu sync QinCe Price ", "FeiShu sync", "approvalInfo：" + approvalInfo, errorMsg);

            return;
        }

        Object productSpec = fieldIdMap.get("productSpec");
        String productName = (String)fieldIdMap.get("productName");
        String productCode = (String)fieldIdMap.get("productCode");
        Object productPrice = fieldIdMap.get("supplyPrice");


        if (StringUtils.isBlank(productCode) || productSpec == null || productPrice == null) {
            String errorMsg = String.format("审批单%s核心字段缺失：编码=%s, 箱规=%s, 供货价=%s",
                    fsInstanceId, productCode, productSpec, productPrice);
            log.error(errorMsg);
            // 调用封装的错误日志记录方法
            if (StringUtils.isBlank(productCode)) {
                productCode = "无";
            }
            if (productSpec == null ){
                productSpec = "无";
            }
            if (productPrice == null){
                productPrice = "无";
            }
            String message = String.format("审批单字段缺失：编码：%s,箱规：%s，供货价：%s", productCode, productSpec, productPrice);
            FeiShuUtils.pustRoot(FeiShuUtil.syncpriceWebhook, message);
            recordErrorLog("QinCe price sync", "QinCe price", "审批单ID：" + fsInstanceId, errorMsg);
            return;
        }

        Integer productSpecValue = Integer.parseInt(productSpec.toString());
        BigDecimal productPriceValue = new BigDecimal(productPrice.toString());
        BigDecimal minSellingPrice = productPriceValue.multiply(new BigDecimal(productSpecValue));

        log.info("审批单{}解析完成：产品名称={}, 编码={}, 箱规={}, 供货价={}, 最小售价={}", fsInstanceId, productName, productCode, productSpec, productPrice, minSellingPrice);

        // 根据产品编码查询勤策的商品信息
        try {
            // 查询勤策商品完整JSON（包含所有原有字段：商品ID、第三方ID等）
            com.alibaba.fastjson.JSONObject qinCeProductJson = qinCeUtils.queryProductInfo(productCode);
            if (qinCeProductJson == null || qinCeProductJson.isEmpty()) {
                 String errorMsg = "勤策未查询到产品编码为" + productCode + "的商品信息";
                log.error(errorMsg);
                recordErrorLog("QinCe price sync", "QinCe price", "产品编码：" + productCode, errorMsg);
                return;
            }
            log.info("从勤策查询到的原始JSON：{}", qinCeProductJson.toJSONString());

            // 校验勤策商品单位信息
            if (qinCeProductJson.getJSONArray("prd_units") != null &&
                    qinCeProductJson.getJSONArray("prd_units").size() <= 1) {
                String message = String.format("检测到产品编码为 %s 的单位信息可能未进行转换", productCode);
                FeiShuUtils.pustRoot(FeiShuUtil.syncpriceWebhook, message);
            }

            com.alibaba.fastjson.JSONObject updateJson = buildQinCeModifyParam(qinCeProductJson, minSellingPrice);

            // 修改勤策商品信息
            boolean isModified = qinCeUtils.modifyProductByFullJson(updateJson);
            log.info("同步价格到勤策结果：产品编码={}，最小售价={}，同步成功={}",
                    productCode, minSellingPrice, isModified);

            // 日志记录
            recordErrorLog("QinCe suggest price sync", "QinCe price",
                    String.format("产品编码：%s，修改字段：prd_suggest_price，修改后值：%s", productCode, minSellingPrice),
                    isModified ? "同步成功" : "同步失败");

        } catch (Exception e) {
            String errorMsg = "处理勤策商品信息异常：" + e.getMessage();
            log.error("处理勤策商品信息时发生异常，产品编码：{}", productCode, e);
            String message = String.format("[ERROR]处理勤策商品信息时发生异常，产品编码：%s", productCode);
            FeiShuUtils.pustRoot(FeiShuUtil.syncpriceWebhook, message);
            recordErrorLog("QinCe price sync error", "QinCe price", "产品编码：" + productCode, errorMsg);
        }
    }

    private void userAUT100(Employee emp){
        String departmentIdV2 = emp.getDepartmentIdV2();
        Department dept = feiShuUtil.getDepartmentCorehr(departmentIdV2);
        String employeeNumber = emp.getEmployeeNumber();
        String deptCode = dept.getCode();
        String legalName = emp.getPersonInfo().getLegalName();
        // 判断部门，当部门为【新人训练营】时跳过，不做人员异动
        if (deptCode.equals("BM0131")){
            log.info("T100-AU-USER skip user：{}{}-新人训练营{}", legalName,employeeNumber,deptCode);
            return;
        }
        BankAccount bankAccount = emp.getPersonInfo().getBankAccountList()[0];
        String bankAccountNumber = bankAccount.getBankAccountNumber();
        JSONObject userT100 = new JSONObject();
        userT100.put("data_status","AU");
        userT100.put("status","Y");
        userT100.put("employee_no",employeeNumber);
        userT100.put("department_no",deptCode);
        userT100.put("site_no","ALL");
        userT100.put("title","");
        userT100.put("bank_no","001");
        userT100.put("account",bankAccountNumber);
        userT100.put("employee_name",legalName);
        userT100.put("employee_nickname",legalName);
        userT100.put("phone","");
        userT100.put("mobilephone","ALL");
        userT100.put("email","");
        String msg = createOrUpdateUser(userT100);
        SysEventLogDto eventDto = new SysEventLogDto()
                .setEventName("T100 user AU")
                .setEventGroup("T100 user")
                .setRequestMsg(JSONObject.toJSONString(userT100))
                .setResponseMsg(msg);
        sysEventLogDao.insert(eventDto);
    }
    private void customFields(CustomFieldData[] customFields,JSONObject deptT100){
        for (CustomFieldData customField : customFields) {
            String customName = customField.getName().getZhCn();
            String customValue = JSONObject.parse(customField.getValue()).getString("zh-CN");
            switch (customName) {
                case "责任中心":
                    deptT100.put("responsibility_center_type",customValue.substring(0,1));
                    break;
                case "费用类别":
                    deptT100.put("fee_type",customValue.substring(0,1));
                    break;
                default:
                    break;
            }
        }
    }

    private String createOrUpdateDept(JSONObject deptT100){
        JSONObject service = new JSONObject();
        service.put("name","department.create");
        JSONObject deptJson = new JSONObject();
        deptJson.put("service",service);
        return t100Util.createOrUpdateDept(deptJson,deptT100);
    }

    private String createOrUpdateUser(JSONObject userT100){
        JSONObject service = new JSONObject();
        service.put("name","employee.create");
        JSONObject payload = new JSONObject();
        payload.putObject("std_data").putObject("parameter").putArray("master_data").add(userT100);
        JSONObject userJson = new JSONObject();
        userJson.put("service",service);
        userJson.put("payload",payload);
        return t100Util.createOrUpdateUser(userJson);
    }


    private void recordErrorLog(String eventName, String eventGroup, String requestMsg, String responseMsg) {
        try {
            SysEventLogDto sysEventLogDto = new SysEventLogDto()
                    .setEventName(eventName)
                    .setEventGroup(eventGroup)
                    .setRequestMsg(JSONObject.toJSONString(requestMsg))
                    .setResponseMsg(responseMsg);
            sysEventLogDao.insert(sysEventLogDto);
        } catch (Exception e) {
            // 日志记录失败时不影响主流程，仅打印错误
            log.error("记录系统错误日志失败，事件名称：{}，请求信息：{}", eventName, requestMsg, e);
        }
    }

    private com.alibaba.fastjson.JSONObject buildQinCeModifyParam(com.alibaba.fastjson.JSONObject qinCeProductJson, BigDecimal minSellingPrice) {
        com.alibaba.fastjson.JSONObject modifyParam = new com.alibaba.fastjson.JSONObject();

        // ========== 定义销售状态映射（文字↔数值） ==========
        Map<String, String> saleStatusMap = new HashMap<>();
        saleStatusMap.put("停售", "0");
        saleStatusMap.put("在售", "1");
        saleStatusMap.put("0", "停售");
        saleStatusMap.put("1", "在售");

        // ========== 顶级字段（严格匹配勤策接口示例字段名） ==========
        // 核心标识字段
        modifyParam.put("prd_id", StringUtils.defaultString(qinCeProductJson.getString("prd_id")));

        // 排序/价格字段
        modifyParam.put("prd_suggest_price", minSellingPrice == null ? BigDecimal.ZERO : minSellingPrice);

        // 销售状态
        String originalSaleStatus = qinCeProductJson.getString("prd_sale_status");
        String standardSaleStatus = StringUtils.defaultString(originalSaleStatus);
        // 转换为标准数值（0=停售，1=在售）
        if (saleStatusMap.containsKey(standardSaleStatus)) {
            standardSaleStatus = standardSaleStatus.matches("[01]") ? standardSaleStatus : saleStatusMap.get(standardSaleStatus);
        }
        modifyParam.put("prd_sale_status", standardSaleStatus);

        // 标签值
        String tagValues = String.join(",",
                StringUtils.defaultString(qinCeProductJson.getString("with_tag_hot")),
                StringUtils.defaultString(qinCeProductJson.getString("with_tag_gift")),
                StringUtils.defaultString(qinCeProductJson.getString("with_tag_new")),
                StringUtils.defaultString(qinCeProductJson.getString("with_tag_sale")),
                StringUtils.defaultString(qinCeProductJson.getString("with_tag_ex1"))
        ).replaceAll("^,|,$", "");
        modifyParam.put("tag_values", tagValues);

        modifyParam.put("prd_price", qinCeProductJson.getBigDecimal("prd_price") == null ? BigDecimal.ZERO : qinCeProductJson.getBigDecimal("prd_price"));

        com.alibaba.fastjson.JSONArray units = new com.alibaba.fastjson.JSONArray();
        com.alibaba.fastjson.JSONArray sourcePrdUnits = qinCeProductJson.getJSONArray("prd_units");
        if (sourcePrdUnits != null && !sourcePrdUnits.isEmpty()) {
            for (int i = 0; i < sourcePrdUnits.size(); i++) {
                com.alibaba.fastjson.JSONObject sourceUnit = sourcePrdUnits.getJSONObject(i);
                if (sourceUnit == null) continue;

                com.alibaba.fastjson.JSONObject unit = new com.alibaba.fastjson.JSONObject();
                // 单位字段严格映射为勤策要求的名称
                unit.put("name", StringUtils.defaultString(sourceUnit.getString("prd_unit_name")));
                unit.put("is_base", StringUtils.defaultString(sourceUnit.getString("prd_is_base")));
                unit.put("ratio", sourceUnit.getBigDecimal("prd_ratio") == null ? 1.00000000 : sourceUnit.getBigDecimal("prd_ratio").doubleValue());
                unit.put("bar_code", StringUtils.defaultString(sourceUnit.getString("prd_barcode")));
                unit.put("weight", StringUtils.defaultString(sourceUnit.getString("prd_weight")));
                unit.put("weight_unit", StringUtils.defaultString(sourceUnit.getString("prd_weight_unit")));

                units.add(unit);
            }
        }
        modifyParam.put("units", units);

        return modifyParam;
    }
}