package com.sfa.job.pojo.response;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * T100出货单中的物流单据
 */
@Accessors(chain = true)
@Data
public class OrdersSentDto implements Serializable {
    /**
     * 发货单自增ID
     */
    private Long sendId;

    /**
     * 单据编号
     */
    /**
     * 单据编号
     */
    private String ahSentNo;
    private String bjSentNo;

    /**
     * 版本号
     */
    private Integer bjSentVersion;


    /**
     * X06:销售出库单;N02:杂发单
     */
    private String type;

    /**
     * 过账日期
     */
    private Date postDate;

    /**
     * 状态
     */
    private String status;

    /**
     * 运输公司编码
     */
    private String transport;

    /**
     * 运输公司
     */
    private String transportName;

    /**
     * 快递单号
     */
    private String expressNo;

    /**
     * DD单号
     */
    private String ddNo;
    /**
     * 经销商编码
     */
    private String dealerCode;
    private String sentStatus;


    /**
     * 签收时间，为空时代表未签收
     */
    private Date operateEndDatetime;

    /**
     * 回单状态：有/无/回单异常
     */
    private String receiptFlag;

    /**
     * 回单图片
     */
    private String receiptPhoto;

    /**
     * 回单图片是否完整
     */
    private String receiptPhotoCompleteFlag;

    private List<OrderSentInfoResponse> sentInfo;


    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}