package com.sfa.job.pojo.order.request;

import com.sfa.job.pojo.order.response.WdtSalesTradeQueryQueryWithDetailDto;
import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;

import java.util.Map;

public class WdtSalesTradeQueryQueryWithDetailVo extends BaseTaobaoRequest<WdtSalesTradeQueryQueryWithDetailDto> {
    private String datetime;
    private String pager;
    private String params;

    private String wdtAppkey;
    private String wdtSalt;
    private String wdtSign;
    private String topContentType;
    private String topResponseType = "qimen1";
    private String topApiVersion = "1.0";
    private String topApiFormat;

    public WdtSalesTradeQueryQueryWithDetailVo() {
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public void setPager(String pager) {
        this.pager = pager;
    }

    public void setPager(WdtSalesTradeQueryQueryWithDetailVo.Pager pager) {
        this.pager = (new JSONWriter(false, false, true)).write(pager);
    }

    public String getPager() {
        return this.pager;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setParams(WdtSalesTradeQueryQueryWithDetailVo.Params params) {
        this.params = (new JSONWriter(false, false, true)).write(params);
    }

    public String getParams() {
        return this.params;
    }
    public void setWdtAppkey(String wdtAppkey) {
        this.wdtAppkey = wdtAppkey;
    }

    public String getWdtAppkey() {
        return this.wdtAppkey;
    }

    public void setWdtSalt(String wdtSalt) {
        this.wdtSalt = wdtSalt;
    }

    public String getWdtSalt() {
        return this.wdtSalt;
    }

    public void setWdtSign(String wdtSign) {
        this.wdtSign = wdtSign;
    }

    public String getWdtSign() {
        return this.wdtSign;
    }

    public String getApiMethodName() {
        return "wdt.sales.tradequery.querywithdetail";
    }

    public String getTopContentType() {
        return this.topContentType;
    }

    public void setTopContentType(String topContentType) {
        this.topContentType = topContentType;
    }

    public String getTopResponseType() {
        return this.topResponseType;
    }

    public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
    }

    public String getTopApiVersion() {
        return this.topApiVersion;
    }

    public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
    }

    public String getTopApiFormat() {
        return this.topApiFormat;
    }

    public void setTopApiFormat(String topApiFormat) {
        this.topApiFormat = topApiFormat;
    }

    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("datetime", this.datetime);
        txtParams.put("pager", this.pager);
        txtParams.put("params", this.params);

        txtParams.put("wdt_appkey", this.wdtAppkey);
        txtParams.put("wdt_salt", this.wdtSalt);
        txtParams.put("wdt_sign", this.wdtSign);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }

        return txtParams;
    }

    public Class<WdtSalesTradeQueryQueryWithDetailDto> getResponseClass() {
        return WdtSalesTradeQueryQueryWithDetailDto.class;
    }

    public void check() throws ApiRuleException {
    }

    public static class Pager {
        @ApiField("page_no")
        private Long pageNo;
        @ApiField("page_size")
        private Long pageSize;

        public Pager() {
        }

        public Long getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Long pageNo) {
            this.pageNo = pageNo;
        }

        public Long getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Long pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class Params {
        @ApiField("start_time")
        private String startTime;
        @ApiField("end_time")
        private String endime;

        @ApiField("shop_no")
        private String shopNo;
        @ApiField("order_type")
        private String orderType;
        /**
         * 1:修改时间 2:付款时间 默认1
         */
        @ApiField("time_type")
        private int timeType;
        @ApiField("cal_share_post_amount")
        private Boolean calSharePostAmount;

        @ApiField("trade_no")
        private String tradeNo;

        public String getTradeNo() {
            return tradeNo;
        }

        public void setTradeNo(String tradeNo) {
            this.tradeNo = tradeNo;
        }

        public String getStartTime() {
            return startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndime() {
            return endime;
        }

        public void setEndime(String endime) {
            this.endime = endime;
        }

        public String getShopNo() {
            return shopNo;
        }

        public void setShopNo(String shopNo) {
            this.shopNo = shopNo;
        }

        public String getOrderType() {
            return orderType;
        }

        public void setOrderType(String orderType) {
            this.orderType = orderType;
        }

        public int getTimeType() {
            return timeType;
        }

        public void setTimeType(int timeType) {
            this.timeType = timeType;
        }

        public Boolean getCalSharePostAmount() {
            return calSharePostAmount;
        }

        public void setCalSharePostAmount(Boolean calSharePostAmount) {
            this.calSharePostAmount = calSharePostAmount;
        }
    }


}
