package com.sfa.job.domain.qince.dao;

import com.sfa.job.pojo.qince.response.QinceUserStatisticDTO;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 勤策考勤用户统计 DAO 接口（纯 DTO 操作，不暴露 Entity）
 *
 */
public interface IQinceUserStatisticDao {

    /**
     * 构建已存在考勤记录的映射（qcUserId+attDate → DTO）
     * @param userIdList 用户ID列表
     * @param dateList 考勤日期列表（Date 类型）
     * @return 唯一键与 DTO 的映射（纯 DTO，无 Entity 暴露）
     */
    Map<String, QinceUserStatisticDTO> buildExistAttendanceMap(List<Long> userIdList, List<LocalDate> dateList);

    /**
     * 批量新增考勤记录（入参为 DTO 列表）
     * @param dtoList 考勤 DTO 列表
     * @return 新增成功条数
     */
    int batchInsert(List<QinceUserStatisticDTO> dtoList);

    /**
     * 批量更新考勤记录（入参为 DTO 列表，需包含主键 ID）
     * @param dtoList 考勤 DTO 列表
     * @return 更新成功条数
     */
    int batchUpdate(List<QinceUserStatisticDTO> dtoList);
}