package com.sfa.job.domain.ls;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.domain.ls.mapper.LsDisStoreMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-11-27 17
 * @describe :
 */
@Slf4j
@DS("bi")
@Service
public class LsDisStoreDaoImpl {

    @Autowired
    private LsDisStoreMapper lsDisStoreMapper;

//    安徽王小卤主体
    public void baiduAddressAnHui(Long ldsId){
        List<LsDisStore> lsDisStores = lsDisStoreMapper.selectBaseO(ldsId);
        if (lsDisStores.isEmpty()){
            return;
        }
        ldsId = lsDisStores.get(lsDisStores.size() - 1).getLdsIf();
        updateanhui(lsDisStores,ldsId);
    }

//    东旭：OI4hMr7tEUoDBhSYxcrOGslnnBfZmD2b
//    秋林：1ZKO0CGs6nm9HuZWR6ucRiu4p9kM8f3i
    private void updateanhui(List<LsDisStore> lsDisStores,Long ldsId){
        for (LsDisStore lsDisStore : lsDisStores) {
            String s = HttpUtil.get("https://api.map.baidu.com/geocoding/v3/?address="+lsDisStore.getOutletAddress()+"&output=json&ak=OI4hMr7tEUoDBhSYxcrOGslnnBfZmD2b");
            JSONObject bd = JSONObject.parseObject(s);
            Integer status = bd.getInteger("status");
            if (status.intValue() >= 300 && status.intValue() <= 399){
                log.info(s);
                return;
            }
            if (status.intValue() != 0){
                continue;
            }

            JSONObject jo = bd.getJSONObject("result");
            JSONObject location = jo.getJSONObject("location");
            Float lng = location.getFloat("lng");
            Float lat = location.getFloat("lat");
            lsDisStore.setLng(lat+","+lng);
//
//            String analysLevel = jo.getString("level");
//            lsDisStore.setLat(analysLevel);
//            if (!analysLevel.equals("省") && !analysLevel.equals("城市")){
//                JSONObject location = jo.getJSONObject("location");
//                Float lng = location.getFloat("lng");
//                Float lat = location.getFloat("lat");
//                lsDisStore.setLng(lat+","+lng);
//            }
        }
        lsDisStoreMapper.updateListO(lsDisStores);
        baiduAddressAnHui(ldsId);
    }

    //    广州王小卤主体
    public void baiduAddressGuangzhou(long ldsId) {
        List<LsDisStore> lsDisStores = lsDisStoreMapper.selectBaseT(ldsId);
        if (lsDisStores.isEmpty()){
            return;
        }
        ldsId = lsDisStores.get(lsDisStores.size() - 1).getLdsIf();
        updateGuangzhou(lsDisStores,ldsId);
    }

//  光浩：sJFYkogPGt8kI3xkkSPwQQ9T61b4GVQV
//  黄总：8ptRbXOnQNX2TTqGVVYv5AUw3vJZ77gZ
    private void updateGuangzhou(List<LsDisStore> lsDisStores,Long ldsId){
        for (LsDisStore lsDisStore : lsDisStores) {
            String s = HttpUtil.get("https://api.map.baidu.com/geocoding/v3/?address="+lsDisStore.getOutletAddress()+"&output=json&ak=sJFYkogPGt8kI3xkkSPwQQ9T61b4GVQV");
            JSONObject bd = JSONObject.parseObject(s);
            Integer status = bd.getInteger("status");
            if (status.intValue() >= 300 && status.intValue() <= 399){
                log.info(s);
                return;
            }
            if (status.intValue() != 0){
                continue;
            }
            JSONObject jo = bd.getJSONObject("result");
            JSONObject location = jo.getJSONObject("location");
            Float lng = location.getFloat("lng");
            Float lat = location.getFloat("lat");
            lsDisStore.setLng(lat+","+lng);
//            String analysLevel = jo.getString("level");
//            lsDisStore.setLat(analysLevel);
//            if (!analysLevel.equals("省") && !analysLevel.equals("城市")){
//                JSONObject location = jo.getJSONObject("location");
//                Float lng = location.getFloat("lng");
//                Float lat = location.getFloat("lat");
//                lsDisStore.setLng(lat+","+lng);
//            }
        }
        lsDisStoreMapper.updateListT(lsDisStores);
        baiduAddressGuangzhou(ldsId);
    }


    public void baiduAddressAnHuisp(Long ldsId){
        List<LsDisStore> lsDisStores = lsDisStoreMapper.selectBaseS(ldsId);
        if (lsDisStores.isEmpty()){
            return;
        }
        ldsId = lsDisStores.get(lsDisStores.size() - 1).getLdsIf();
        updateanhuisp(lsDisStores,ldsId);
    }

//    欣雨：StY6BS8Bw50TrclA4Zd52MfEjsL1zUXI
//    本才：anjhOkUMuRyTb3DZO6dMGRUCY2l0vAql
    private void updateanhuisp(List<LsDisStore> lsDisStores,Long ldsId){
        for (LsDisStore lsDisStore : lsDisStores) {
            String s = HttpUtil.get("https://api.map.baidu.com/geocoding/v3/?address="+lsDisStore.getOutletAddress()+"&output=json&ak=anjhOkUMuRyTb3DZO6dMGRUCY2l0vAql");
            JSONObject bd = JSONObject.parseObject(s);
            Integer status = bd.getInteger("status");
            if (status.intValue() >= 300 && status.intValue() <= 399){
                log.info(s);
                return;
            }
            if (status.intValue() != 0){
                continue;
            }
            JSONObject jo = bd.getJSONObject("result");
            JSONObject location = jo.getJSONObject("location");
            Float lng = location.getFloat("lng");
            Float lat = location.getFloat("lat");
            lsDisStore.setLng(lat+","+lng);

//            String analysLevel = jo.getString("level");
//            lsDisStore.setLat(analysLevel);
//            if (!analysLevel.equals("省") && !analysLevel.equals("城市")){
//                JSONObject location = jo.getJSONObject("location");
//                Float lng = location.getFloat("lng");
//                Float lat = location.getFloat("lat");
//                lsDisStore.setLng(lat+","+lng);
//            }
        }
        lsDisStoreMapper.updateListS(lsDisStores);
        baiduAddressAnHuisp(ldsId);
    }

    public void nAddreasAnHui(long ldsId) {
        List<LsDisStore> lsDisStores = lsDisStoreMapper.selectBaseLO(ldsId);
        if (lsDisStores.isEmpty()){
            return;
        }
        ldsId = lsDisStores.get(lsDisStores.size() - 1).getLdsIf();
        nUanhuisp(lsDisStores,ldsId);
    }

//    洪虎：Ltqlx9VbzkCs1BiVvErlzkjDBc1htKUb
    private void nUanhuisp(List<LsDisStore> lsDisStores,Long ldsId){
        for (LsDisStore lsDisStore : lsDisStores) {
            String lng = lsDisStore.getLng();
            String s = HttpUtil.get("https://api.map.baidu.com/reverse_geocoding/v3/?location="+lng+"&output=json&ak=Ltqlx9VbzkCs1BiVvErlzkjDBc1htKUb");
            JSONObject bd = JSONObject.parseObject(s);
            Integer status = bd.getInteger("status");
            if (status.intValue() >= 300 && status.intValue() <= 399){
                log.info(s);
                return;
            }
            if (status.intValue() != 0){
                continue;
            }
            JSONObject jo = bd.getJSONObject("result");
            String formattedAddress = jo.getString("formatted_address");

            JSONObject ac = jo.getJSONObject("addressComponent");
            String province = ac.getString("province");
            String city = ac.getString("city");
            String district = ac.getString("district");
            lsDisStore.setReProvince(province);
            lsDisStore.setReAddress(formattedAddress);
            lsDisStore.setReCity(city);
            lsDisStore.setReArea(district);
        }
        lsDisStoreMapper.updateListNO(lsDisStores);
        nAddreasAnHui(ldsId);
    }



    public void lsStoreNXY(long ldsId) {
        List<LsDisStore> lsDisStores = lsDisStoreMapper.selectBaseLT(ldsId);
        if (lsDisStores.isEmpty()){
            return;
        }
        ldsId = lsDisStores.get(lsDisStores.size() - 1).getLdsIf();
        nUXY(lsDisStores,ldsId);
    }

    private void nUXY(List<LsDisStore> lsDisStores,Long ldsId){
        for (LsDisStore lsDisStore : lsDisStores) {
            String lng = lsDisStore.getLng();
            String s = HttpUtil.get("https://api.map.baidu.com/reverse_geocoding/v3/?location="+lng+"&output=json&ak=StY6BS8Bw50TrclA4Zd52MfEjsL1zUXI");
            JSONObject bd = JSONObject.parseObject(s);
            Integer status = bd.getInteger("status");
            if (status.intValue() >= 300 && status.intValue() <= 399){
                log.info(s);
                return;
            }
            if (status.intValue() != 0){
                continue;
            }
            JSONObject jo = bd.getJSONObject("result");
            String formattedAddress = jo.getString("formatted_address");

            JSONObject ac = jo.getJSONObject("addressComponent");
            String province = ac.getString("province");
            String city = ac.getString("city");
            String district = ac.getString("district");
            lsDisStore.setReProvince(province);
            lsDisStore.setReAddress(formattedAddress);
            lsDisStore.setReCity(city);
            lsDisStore.setReArea(district);
        }
        lsDisStoreMapper.updateListNO(lsDisStores);
        lsStoreNXY(ldsId);
    }

    public void lsStoreNGH(long ldsId) {
        List<LsDisStore> lsDisStores = lsDisStoreMapper.selectBaseLS(ldsId);
        if (lsDisStores.isEmpty()){
            return;
        }
        ldsId = lsDisStores.get(lsDisStores.size() - 1).getLdsIf();
        nUGH(lsDisStores,ldsId);
    }

    private void nUGH(List<LsDisStore> lsDisStores, long ldsId) {
        for (LsDisStore lsDisStore : lsDisStores) {
            String lng = lsDisStore.getLng();
            String s = HttpUtil.get("https://api.map.baidu.com/reverse_geocoding/v3/?location="+lng+"&output=json&ak=sJFYkogPGt8kI3xkkSPwQQ9T61b4GVQV");
            JSONObject bd = JSONObject.parseObject(s);
            Integer status = bd.getInteger("status");
            if (status.intValue() >= 300 && status.intValue() <= 399){
                log.info(s);
                return;
            }
            if (status.intValue() != 0){
                continue;
            }
            JSONObject jo = bd.getJSONObject("result");
            String formattedAddress = jo.getString("formatted_address");

            JSONObject ac = jo.getJSONObject("addressComponent");
            String province = ac.getString("province");
            String city = ac.getString("city");
            String district = ac.getString("district");
            lsDisStore.setReProvince(province);
            lsDisStore.setReAddress(formattedAddress);
            lsDisStore.setReCity(city);
            lsDisStore.setReArea(district);
        }
        lsDisStoreMapper.updateListNO(lsDisStores);
        lsStoreNGH(ldsId);
    }

    public void lsStoreNHS(long ldsId) {
        List<LsDisStore> lsDisStores = lsDisStoreMapper.selectBaseLF(ldsId);
        if (lsDisStores.isEmpty()){
            return;
        }
        ldsId = lsDisStores.get(lsDisStores.size() - 1).getLdsIf();
        nUHS(lsDisStores,ldsId);
    }

    private void nUHS(List<LsDisStore> lsDisStores, long ldsId) {
        for (LsDisStore lsDisStore : lsDisStores) {
            String lng = lsDisStore.getLng();
            String s = HttpUtil.get("https://api.map.baidu.com/reverse_geocoding/v3/?location="+lng+"&output=json&ak=8ptRbXOnQNX2TTqGVVYv5AUw3vJZ77gZ");
            JSONObject bd = JSONObject.parseObject(s);
            Integer status = bd.getInteger("status");
            if (status.intValue() >= 300 && status.intValue() <= 399){
                log.info(s);
                return;
            }
            if (status.intValue() != 0){
                continue;
            }
            JSONObject jo = bd.getJSONObject("result");
            String formattedAddress = jo.getString("formatted_address");

            JSONObject ac = jo.getJSONObject("addressComponent");
            String province = ac.getString("province");
            String city = ac.getString("city");
            String district = ac.getString("district");
            lsDisStore.setReProvince(province);
            lsDisStore.setReAddress(formattedAddress);
            lsDisStore.setReCity(city);
            lsDisStore.setReArea(district);
        }
        lsDisStoreMapper.updateListNO(lsDisStores);
        lsStoreNHS(ldsId);
    }

    public void lsStoreNDX(long ldsId) {
        List<LsDisStore> lsDisStores = lsDisStoreMapper.selectBaseLV(ldsId);
        if (lsDisStores.isEmpty()){
            return;
        }
        ldsId = lsDisStores.get(lsDisStores.size() - 1).getLdsIf();
        nUDX(lsDisStores,ldsId);
    }

    private void nUDX(List<LsDisStore> lsDisStores, long ldsId) {
        for (LsDisStore lsDisStore : lsDisStores) {
            String lng = lsDisStore.getLng();
            String s = HttpUtil.get("https://api.map.baidu.com/reverse_geocoding/v3/?location="+lng+"&output=json&ak=OI4hMr7tEUoDBhSYxcrOGslnnBfZmD2b");
            JSONObject bd = JSONObject.parseObject(s);
            Integer status = bd.getInteger("status");
            if (status.intValue() >= 300 && status.intValue() <= 399){
                log.info(s);
                return;
            }
            if (status.intValue() != 0){
                continue;
            }
            JSONObject jo = bd.getJSONObject("result");
            String formattedAddress = jo.getString("formatted_address");

            JSONObject ac = jo.getJSONObject("addressComponent");
            String province = ac.getString("province");
            String city = ac.getString("city");
            String district = ac.getString("district");
            lsDisStore.setReProvince(province);
            lsDisStore.setReAddress(formattedAddress);
            lsDisStore.setReCity(city);
            lsDisStore.setReArea(district);
        }
        lsDisStoreMapper.updateListNO(lsDisStores);
        lsStoreNDX(ldsId);
    }

    public void lsStoreNQL(long ldsId) {
        List<LsDisStore> lsDisStores = lsDisStoreMapper.selectBaseLX(ldsId);
        if (lsDisStores.isEmpty()){
            return;
        }
        ldsId = lsDisStores.get(lsDisStores.size() - 1).getLdsIf();
        nUQL(lsDisStores,ldsId);
    }

    private void nUQL(List<LsDisStore> lsDisStores, long ldsId) {
        for (LsDisStore lsDisStore : lsDisStores) {
            String lng = lsDisStore.getLng();
            String s = HttpUtil.get("https://api.map.baidu.com/reverse_geocoding/v3/?location="+lng+"&output=json&ak=1ZKO0CGs6nm9HuZWR6ucRiu4p9kM8f3i");
            JSONObject bd = JSONObject.parseObject(s);
            Integer status = bd.getInteger("status");
            if (status.intValue() >= 300 && status.intValue() <= 399){
                log.info(s);
                return;
            }
            if (status.intValue() != 0){
                continue;
            }
            JSONObject jo = bd.getJSONObject("result");
            String formattedAddress = jo.getString("formatted_address");

            JSONObject ac = jo.getJSONObject("addressComponent");
            String province = ac.getString("province");
            String city = ac.getString("city");
            String district = ac.getString("district");
            lsDisStore.setReProvince(province);
            lsDisStore.setReAddress(formattedAddress);
            lsDisStore.setReCity(city);
            lsDisStore.setReArea(district);
        }
        lsDisStoreMapper.updateListNO(lsDisStores);
        lsStoreNQL(ldsId);
    }
}
