package com.sfa.job.domain.feishu.dao;

import com.sfa.job.pojo.feishu.response.FeishuLeaveInfoDTO;

import java.util.List;

/**
 * Dao接口：定义所有核心方法，Service仅调用此处方法
 */
public interface FeishuLeaveInfoDao {
    /**
     * 解析飞书原始JSON为DTO列表（核心解析逻辑）
     */
    List<FeishuLeaveInfoDTO> parseFeishuLeaveRawJson(String rawJson);

    /**
     * 同步飞书请假数据（核心新增/更新逻辑）
     */
    String syncFeishuLeaveData(String syncDate);

    /**
     * 根据请假唯一ID查询DTO
     */
    FeishuLeaveInfoDTO selectByLeaveRequestId(String leaveRequestId);
}