package com.sfa.job.controller.finance;

import cn.hutool.core.date.DateUtil;
import com.sfa.common.core.web.controller.BaseController;
import com.sfa.job.pojo.response.FinanceOrderDetailUpdateDto;
import com.sfa.job.pojo.response.SyncOrderDetailDto;
import com.sfa.job.service.order.IFinanceOrderSyncService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * 调度任务信息操作处理
 *
 * @author ruoyi
 */
@Slf4j
@RestController
@RequestMapping("/finance/order")
public class FinanceOrderDetailSyncController extends BaseController {
    @Autowired
    private IFinanceOrderSyncService syncService;

    @GetMapping("/syncWdtOrderDetail")
    public SyncOrderDetailDto syncWangdiantongOrderDetail(Date startTime, Date endTime) {
        log.info("接口开始同步-旺店通订单明细api接口数据");
        // 可以传参开始时间和结束时间，用于补充特定时间的数据采集
        SyncOrderDetailDto detailDto = syncService.syncWdtOrder(startTime, endTime, 1);
        log.info("接口结束同步-旺店通订单明细api接口数据, 共同步订单{}条数据，订单明细{}条,订单批次号：{},订单的开始时间{}和结束时间{}",
                detailDto.getOrderCount(), detailDto.getOrderDetailCount(), detailDto.getBatchNo(),
                DateUtil.formatDateTime(detailDto.getStartTime()), DateUtil.formatDateTime(detailDto.getEndTime()));
        return detailDto;
    }

    @GetMapping("/updateCost")
    public FinanceOrderDetailUpdateDto updateCost(Date startTime, Date endTime) {
        log.info("修改旺店通订单明细数据开始");
        // 可以传参开始时间和结束时间，用于补充特定时间的数据采集
        FinanceOrderDetailUpdateDto detailDto = syncService.updateCost(startTime, endTime);
        log.info("修改旺店通订单明细结束-旺店通订单明细api接口数据, 共修改订单数{}条数据", detailDto.getTotalCount());
        return detailDto;
    }

    @GetMapping("/syncWdtRefundOrder")
    public SyncOrderDetailDto syncWdtRefundOrder(Date startTime, Date endTime) {
        log.info("开始接口同步-旺店通退换订单明细api接口数据");
        // 可以传参开始时间和结束时间，用于补充特定时间的数据采集
        SyncOrderDetailDto detailDto = syncService.syncWdtRefundOrder(startTime, endTime, 1);
        log.info("结束接口同步-旺店通退换订单明细api接口数据, 共同步退换货订单{}条数据，退换货订单明细{}条,退换货同步批次号：{},订单的开始时间{}和结束时间{},数量：{}",
                detailDto.getOrderCount(), detailDto.getOrderDetailCount(), detailDto.getBatchNo(),
                DateUtil.formatDateTime(detailDto.getStartTime()), DateUtil.formatDateTime(detailDto.getEndTime()), detailDto.getRemark());
        return detailDto;
    }


}
