package com.sfa.job.config;

import com.alibaba.cloud.nacos.NacosConfigAutoConfiguration;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.baomidou.dynamic.datasource.provider.AbstractDataSourceProvider;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.sfa.job.util.NacosConfigiServiceUtils;
import org.apache.shardingsphere.driver.api.yaml.YamlShardingSphereDataSourceFactory;
import org.apache.shardingsphere.driver.jdbc.core.driver.ShardingSphereURLProvider;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.annotation.Resource;
import javax.sql.DataSource;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;

@Configuration
@AutoConfigureAfter(DataSourceAutoConfiguration.class)
@EnableConfigurationProperties({DataSourceProperties.class})
@ConditionalOnClass(NacosConfigAutoConfiguration.class)
public class ShardingConfiguration {

    @Resource
    private DynamicDataSourceProperties properties;

    @Resource
    private NacosConfigProperties nacosConfigProperties;

    @Value("${spring.shardindsphereUrl}")
    private String shardingsphereUrl;

    @Bean
    @Primary
    public DynamicDataSourceProvider dynamicDataSourceProvider() {
        NacosConfigiServiceUtils.init(nacosConfigProperties);
        Map<String, DataSourceProperty> datasourceMap = properties.getDatasource();
        return new AbstractDataSourceProvider() {
            @Override
            public Map<String, DataSource> loadDataSources() {
                Map<String, DataSource> dataSourceMap = createDataSourceMap(datasourceMap);
                //SPI机制
                Collection<ShardingSphereURLProvider> provider = ShardingSphereServiceLoader.getServiceInstances(ShardingSphereURLProvider.class);
                provider.forEach(item -> {
                    if (item.accept(shardingsphereUrl)) {
                        try {
                            DataSource dataSource = YamlShardingSphereDataSourceFactory.createDataSource(item.getContent(shardingsphereUrl,"jdbc:shardingsphere:"));
                            dataSourceMap.put("sharding", dataSource);
                        } catch (SQLException e) {
                            e.printStackTrace();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                return dataSourceMap;
            }
        };
    }
}
