package com.sfa.job.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;

/**
 * @author : liqiulin
 * @date : 2025-06-19 17
 * @describe : T100接口对接
 */
@Slf4j
@Component
public class T100Util {

    @Value("${t100.url}")
    private String url;

    public void createOrUpdateDept(JSONObject deptJson){
        HashMap<String,String> header = new HashMap<>();
        header.put("Content-Type","application/json;charset=utf-8");
        header.put("digi-protocol","raw");
        header.put("digi-srvver","1.0");
        header.put("digi-srvcode","000");
        header.put("digi-type","sync");
        header.put("digi-key","f63b06af224e90ea3f9f08e0226fc91e");
        String body = HttpUtil.createPost(url).addHeaders(header).body(deptJson.toString()).execute().body();
        log.info("\nT100-创建/修改部门\n参数：{}\n结果：{}",deptJson,body);
    }

    public void createOrUpdateUser(JSONObject userJson) {
        HashMap<String,String> header = new HashMap<>();
        header.put("Content-Type","application/json;charset=utf-8");
        header.put("digi-protocol","raw");
        header.put("digi-srvver","1.0");
        header.put("digi-srvcode","000");
        header.put("digi-type","sync");
        header.put("digi-key","f63b06af224e90ea3f9f08e0226fc91e");
        String body = HttpUtil.createPost(url).addHeaders(header).body(userJson.toString()).execute().body();
        log.info("\nT100-创建/修改人员\n参数：{}\n结果：{}",userJson,body);

    }
}
