package com.sfa.job.xxljob.system;

import com.sfa.job.service.system.IDeptAndUserService;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author : liqiulin
 * @date : 2024-12-10 16
 * @describe :系统数据任务
 */
@Component
@Slf4j
public class SystemTask {

    @Autowired
    IDeptAndUserService deptAndUserService;

    /**
     * 同步部门数据
     */
    @XxlJob("sync_feishu_dept")
    public void deptAll() {
        log.info("开始同步部门数据");
        deptAndUserService.deptAll();
        log.info("结束同步部门数据");
    }

    /**
     * 同步人员
     */
    @XxlJob("sync_feishu_user")
    public void userAll() {
        log.info("开始同步飞书用户数据");
        deptAndUserService.userAll();
        log.info("结束同步飞书用户数据");
    }

    /**
     * 同步人员离职
     */
    @XxlJob("sync_user_resigned")
    public void userResigned() {
        log.info("开始处理离职人员");
        deptAndUserService.usersResigned();
        log.info("结束处理离职人员");
    }
}
